/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.core.expected.list.messages;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jupiter.tools.spring.test.core.expected.list.messages.ExpectedMessagesOptions;
import com.jupiter.tools.spring.test.core.expected.list.messages.Fail;
import com.jupiter.tools.spring.test.core.expected.list.messages.MessageBroker;
import com.jupiter.tools.spring.test.core.importdata.DataSet;
import com.jupiter.tools.spring.test.core.importdata.ImportFile;
import com.jupiter.tools.spring.test.core.importdata.JsonImport;
import java.util.List;
import java.util.Map;

public class AssertReceivedMessages {
    private final ExpectedMessagesOptions expectedMessagesOptions;
    private final MessageBroker messageBroker;
    private final ObjectMapper mapper;

    public AssertReceivedMessages(ExpectedMessagesOptions expectedMessagesOptions, MessageBroker messageBroker) {
        this.expectedMessagesOptions = expectedMessagesOptions;
        this.messageBroker = messageBroker;
        this.mapper = new ObjectMapper();
    }

    public void doAssert() {
        if (this.expectedMessagesOptions == null) {
            return;
        }
        JsonImport expectedDataSet = new JsonImport(new ImportFile(this.expectedMessagesOptions.getMessagesFile()));
        if (this.isEmptyDataSet(expectedDataSet)) {
            this.processingEmptyDataSet(this.expectedMessagesOptions);
            return;
        }
        this.processingDataSet(this.expectedMessagesOptions, expectedDataSet);
    }

    private boolean isEmptyDataSet(DataSet dataSet) {
        Map<String, List<Map<String, Object>>> readDataSet = dataSet.read();
        return readDataSet.isEmpty() || readDataSet.entrySet().stream().allMatch(e -> ((List)e.getValue()).isEmpty());
    }

    private void processingEmptyDataSet(ExpectedMessagesOptions expectedMessagesOptions) {
        if (expectedMessagesOptions.isIgnoreUnexpected()) {
            return;
        }
        Object message = this.messageBroker.receive(expectedMessagesOptions.getQueue(), expectedMessagesOptions.getTimeout());
        if (message != null) {
            new Fail("not expected but found:").withObject(message).fire();
        }
    }

    private void processingDataSet(ExpectedMessagesOptions expectedMessagesOptions, DataSet expectedDataSet) {
        Map<String, List<Map<String, Object>>> expectedDataMap = expectedDataSet.read();
        long startTime = System.currentTimeMillis();
        boolean processing = true;
        while (processing) {
            Object message = this.messageBroker.receive(expectedMessagesOptions.getQueue(), expectedMessagesOptions.getTimeout());
            if (message == null) {
                new Fail("expected but not found:").withObject(expectedDataMap).fire();
            }
            this.assertReceivedMessage(expectedMessagesOptions, expectedDataMap, message);
            if (!this.isEmptyDataMap(expectedDataMap) && !this.timeLimit(startTime, expectedMessagesOptions.getTimeout())) continue;
            processing = false;
        }
    }

    private void assertReceivedMessage(ExpectedMessagesOptions expectedMessages, Map<String, List<Map<String, Object>>> expectedDataMap, Object message) {
        String className = message.getClass().getCanonicalName();
        if (!expectedDataMap.containsKey(className)) {
            if (expectedMessages.isIgnoreUnexpected()) {
                return;
            }
            new Fail("not expected but found:").withObject(message).fire();
        }
        Map map = (Map)this.mapper.convertValue(message, Map.class);
        if (!expectedDataMap.get(className).contains(map)) {
            if (expectedMessages.isIgnoreUnexpected()) {
                return;
            }
            new Fail("not expected but found: `" + className + "`:").withObject(message).fire();
        }
        this.removeEntryFromExpected(expectedDataMap, className, map);
    }

    private boolean timeLimit(long startTime, long timeout) {
        return System.currentTimeMillis() - startTime > timeout;
    }

    private void removeEntryFromExpected(Map<String, List<Map<String, Object>>> source, String entryClassName, Map<String, Object> entry) {
        source.get(entryClassName).remove(entry);
        if (source.get(entryClassName).isEmpty()) {
            source.remove(entryClassName);
        }
    }

    private boolean isEmptyDataMap(Map<String, List<Map<String, Object>>> dataMap) {
        return dataMap.values().stream().allMatch(List::isEmpty);
    }
}

