/*
 * Decompiled with CFR 0.152.
 */
package regexodus.ds;

import com.jtransc.annotation.JTranscInvisible;
import java.io.Serializable;
import java.util.Arrays;

@JTranscInvisible
public class CharCharMap
implements Serializable,
Cloneable {
    private static final boolean ASSERTS = false;
    protected transient char[] key;
    protected transient char[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected int size;
    protected final float f;
    protected volatile transient KeySet keys;
    protected char defRetValue;
    public static final int DEFAULT_INITIAL_SIZE = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public CharCharMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = CharCharMap.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = CharCharMap.maxFill(this.n, f);
        this.key = new char[this.n + 1];
        this.value = new char[this.n + 1];
    }

    public CharCharMap(int expected) {
        this(expected, 0.75f);
    }

    public CharCharMap() {
        this(16, 0.75f);
    }

    public CharCharMap(char[] k, char[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public CharCharMap(char[] k, char[] v) {
        this(k, v, 0.75f);
    }

    public void defaultReturnValue(char rv) {
        this.defRetValue = rv;
    }

    public char defaultReturnValue() {
        return this.defRetValue;
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = CharCharMap.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private char removeEntry(int pos) {
        char oldValue = this.value[pos];
        --this.size;
        this.shiftKeys(pos);
        if (this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private char removeNullEntry() {
        this.containsNullKey = false;
        char oldValue = this.value[this.n];
        --this.size;
        if (this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private int insert(char k, char v) {
        int pos;
        if (k == '\u0000') {
            if (this.containsNullKey) {
                return this.n;
            }
            this.containsNullKey = true;
            pos = this.n;
        } else {
            char[] key = this.key;
            pos = HashCommon.mix(k) & this.mask;
            char curr = key[pos];
            if (curr != '\u0000') {
                if (curr == k) {
                    return pos;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != '\u0000') {
                    if (curr != k) continue;
                    return pos;
                }
            }
        }
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(CharCharMap.arraySize(this.size + 1, this.f));
        }
        return -1;
    }

    public char put(char k, char v) {
        int pos = this.insert(k, v);
        if (pos < 0) {
            return this.defRetValue;
        }
        char oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    protected final void shiftKeys(int pos) {
        char[] key = this.key;
        while (true) {
            char curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == '\u0000') {
                    key[last] = '\u0000';
                    return;
                }
                int slot = HashCommon.mix(curr) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos];
        }
    }

    public char remove(char k) {
        if (k == '\u0000') {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        char[] key = this.key;
        int pos = HashCommon.mix(k) & this.mask;
        char curr = key[pos];
        if (curr == '\u0000') {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != '\u0000') continue;
            return this.defRetValue;
        } while (k != curr);
        return this.removeEntry(pos);
    }

    public char get(char k) {
        if (k == '\u0000') {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        char[] key = this.key;
        int pos = HashCommon.mix(k) & this.mask;
        char curr = key[pos];
        if (curr == '\u0000') {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != '\u0000') continue;
            return this.defRetValue;
        } while (k != curr);
        return this.value[pos];
    }

    public boolean containsKey(char k) {
        if (k == '\u0000') {
            return this.containsNullKey;
        }
        char[] key = this.key;
        int pos = HashCommon.mix(k) & this.mask;
        char curr = key[pos];
        if (curr == '\u0000') {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != '\u0000') continue;
            return false;
        } while (k != curr);
        return true;
    }

    public boolean containsValue(char v) {
        char[] value = this.value;
        char[] key = this.key;
        if (this.containsNullKey && value[this.n] == v) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (key[i] == '\u0000' || value[i] != v) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, '\u0000');
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public KeySet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public boolean trim() {
        int l = CharCharMap.arraySize(this.size, this.f);
        if (l >= this.n || this.size > CharCharMap.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (Error cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= n || this.size > CharCharMap.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (Error cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        char[] key = this.key;
        char[] value = this.value;
        int mask = newN - 1;
        char[] newKey = new char[newN + 1];
        char[] newValue = new char[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == '\u0000') {
            }
            int pos = HashCommon.mix(key[i]) & mask;
            if (newKey[pos] != '\u0000') {
                while (newKey[pos = pos + 1 & mask] != '\u0000') {
                }
            }
            newKey[pos] = key[i];
            newValue[pos] = value[i];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = CharCharMap.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public CharCharMap clone() {
        char[] k = new char[this.key.length];
        char[] v = new char[this.value.length];
        System.arraycopy(this.key, 0, k, 0, this.key.length);
        System.arraycopy(this.value, 0, v, 0, this.value.length);
        return new CharCharMap(k, v, this.f);
    }

    public int hashCode() {
        int h = 0;
        int j = this.realSize();
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (this.key[i] == '\u0000') {
                ++i;
            }
            t = this.key[i];
            h += (t ^= this.value[i]);
            ++i;
        }
        if (this.containsNullKey) {
            h += this.value[this.n];
        }
        return h;
    }

    public static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    public static long maxFill(long n, float f) {
        return Math.min((long)Math.ceil((float)n * f), n - 1L);
    }

    public static int arraySize(int expected, float f) {
        long s = Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    private static class HashCommon {
        public static final Object REMOVED = new Object();
        private static final int INT_PHI = -1640531527;
        private static final int INV_INT_PHI = 340573321;
        private static final long LONG_PHI = -7046029254386353131L;
        private static final long INV_LONG_PHI = -1018231460777725123L;

        private HashCommon() {
        }

        public static final int murmurHash3(int x) {
            x ^= x >>> 16;
            x *= -2048144789;
            x ^= x >>> 13;
            x *= -1028477387;
            x ^= x >>> 16;
            return x;
        }

        public static final long murmurHash3(long x) {
            x ^= x >>> 33;
            x *= -49064778989728563L;
            x ^= x >>> 33;
            x *= -4265267296055464877L;
            x ^= x >>> 33;
            return x;
        }

        public static final int mix(int x) {
            int h = x * -1640531527;
            return h ^ h >>> 16;
        }

        public static final int invMix(int x) {
            return (x ^ x >>> 16) * 340573321;
        }

        public static final long mix(long x) {
            long h = x * -7046029254386353131L;
            h ^= h >>> 32;
            return h ^ h >>> 16;
        }

        public static final long invMix(long x) {
            x ^= x >>> 32;
            x ^= x >>> 16;
            return (x ^ x >>> 32) * -1018231460777725123L;
        }

        public static final int float2int(float f) {
            return Float.floatToIntBits(f);
        }

        public static final int double2int(double d) {
            long l = Double.doubleToLongBits(d);
            return (int)(l ^ l >>> 32);
        }

        public static final int long2int(long l) {
            return (int)(l ^ l >>> 32);
        }

        public static int nextPowerOfTwo(int x) {
            if (x == 0) {
                return 1;
            }
            --x;
            x |= x >> 1;
            x |= x >> 2;
            x |= x >> 4;
            x |= x >> 8;
            return (x | x >> 16) + 1;
        }

        public static long nextPowerOfTwo(long x) {
            if (x == 0L) {
                return 1L;
            }
            --x;
            x |= x >> 1;
            x |= x >> 2;
            x |= x >> 4;
            x |= x >> 8;
            x |= x >> 16;
            return (x | x >> 32) + 1L;
        }

        public static long bigArraySize(long expected, float f) {
            return HashCommon.nextPowerOfTwo((long)Math.ceil((float)expected / f));
        }
    }

    private final class KeySet {
        private KeySet() {
        }

        public int size() {
            return CharCharMap.this.size;
        }

        public boolean contains(char k) {
            return CharCharMap.this.containsKey(k);
        }

        public boolean remove(char k) {
            int oldSize = CharCharMap.this.size;
            CharCharMap.this.remove(k);
            return CharCharMap.this.size != oldSize;
        }

        public void clear() {
            CharCharMap.this.clear();
        }

        public boolean remove(Object o) {
            return this.remove(((Character)o).charValue());
        }
    }
}

