/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.jtransc.compression.JTranscZlib;
import com.jtransc.io.ra.RAFile;
import com.jtransc.io.ra.RASlice;
import com.jtransc.io.ra.RAStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import libcore.io.BufferIterator;
import libcore.io.HeapBufferIterator;

public class ZipFile
implements Closeable,
ZipConstants {
    static final int GPBF_ENCRYPTED_FLAG = 1;
    static final int GPBF_DATA_DESCRIPTOR_FLAG = 8;
    static final int GPBF_UTF8_FLAG = 2048;
    static final int GPBF_UNSUPPORTED_MASK = 1;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final String filename;
    private File fileToDeleteOnClose;
    private RAStream ras;
    private final LinkedHashMap<String, ZipEntry> entries = new LinkedHashMap();
    private String comment;

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    public ZipFile(File file, int mode) throws IOException {
        this.filename = file.getPath();
        if (mode != 1 && mode != 5) {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if ((mode & 4) != 0) {
            this.fileToDeleteOnClose = file;
            this.fileToDeleteOnClose.deleteOnExit();
        } else {
            this.fileToDeleteOnClose = null;
        }
        this.ras = new RAFile(file);
        this.readCentralDir();
    }

    protected void finalize() throws IOException {
        try {
            super.finalize();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RAStream localRaf = this.ras;
        if (localRaf != null) {
            RAStream rAStream = localRaf;
            synchronized (rAStream) {
                this.ras = null;
                localRaf.close();
            }
            if (this.fileToDeleteOnClose != null) {
                this.fileToDeleteOnClose.delete();
                this.fileToDeleteOnClose = null;
            }
        }
    }

    private void checkNotClosed() {
        if (this.ras == null) {
            throw new IllegalStateException("Zip file closed");
        }
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.checkNotClosed();
        final Iterator iterator = this.entries.values().iterator();
        return new Enumeration<ZipEntry>(){

            @Override
            public boolean hasMoreElements() {
                ZipFile.this.checkNotClosed();
                return iterator.hasNext();
            }

            @Override
            public ZipEntry nextElement() {
                ZipFile.this.checkNotClosed();
                return (ZipEntry)iterator.next();
            }
        };
    }

    public String getComment() {
        this.checkNotClosed();
        return this.comment;
    }

    public ZipEntry getEntry(String entryName) {
        this.checkNotClosed();
        if (entryName == null) {
            throw new NullPointerException("entryName == null");
        }
        ZipEntry ze = this.entries.get(entryName);
        if (ze == null) {
            ze = this.entries.get(entryName + "/");
        }
        return ze;
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        if ((entry = this.getEntry(entry.getName())) == null) {
            return null;
        }
        RASlice is = this.ras.sliceAvailable(entry.localHeaderRelOffset);
        int localMagic = is.readS32_LE();
        if ((long)localMagic != 67324752L) {
            ZipFile.throwZipException("Local File Header", localMagic);
        }
        is.skip(2L);
        int gpbf = is.readU16_LE();
        if ((gpbf & 1) != 0) {
            throw new ZipException("Invalid General Purpose Bit Flag: " + gpbf);
        }
        is.skip(18L);
        int fileNameLength = is.readU16_LE();
        int extraFieldLength = is.readU16_LE();
        is.close();
        is.skip((long)(fileNameLength + extraFieldLength));
        RASlice data = is.readSlice(entry.compressedSize);
        if (entry.compressionMethod == 0) {
            return new ByteArrayInputStream(data.getAllBytes());
        }
        return new ByteArrayInputStream(JTranscZlib.inflate((byte[])data.getAllBytes(), (int)((int)entry.size)));
    }

    public String getName() {
        return this.filename;
    }

    public int size() {
        this.checkNotClosed();
        return this.entries.size();
    }

    private void readCentralDir() throws IOException {
        block8: {
            long scanOffset = this.ras.length() - 22L;
            if (scanOffset < 0L) {
                throw new ZipException("File too short to be a zip file: " + this.ras.length());
            }
            this.ras.setPosition(0L);
            int headerMagic = this.ras.readS32_LE();
            if ((long)headerMagic != 67324752L) {
                throw new ZipException("Not a zip archive");
            }
            long stopOffset = scanOffset - 65536L;
            if (stopOffset < 0L) {
                stopOffset = 0L;
            }
            do {
                this.ras.setPosition(scanOffset);
                if ((long)this.ras.readS32_LE() == 101010256L) break block8;
            } while (--scanOffset >= stopOffset);
            throw new ZipException("End Of Central Directory signature not found");
        }
        byte[] eocd = this.ras.readBytes(18);
        BufferIterator it = HeapBufferIterator.iterator(eocd, 0, eocd.length, ByteOrder.LITTLE_ENDIAN);
        int diskNumber = it.readShort() & 0xFFFF;
        int diskWithCentralDir = it.readShort() & 0xFFFF;
        int numEntries = it.readShort() & 0xFFFF;
        int totalNumEntries = it.readShort() & 0xFFFF;
        long centralDirSize = (long)it.readInt() & 0xFFFFFFFFL;
        long centralDirOffset = (long)it.readInt() & 0xFFFFFFFFL;
        int commentLength = it.readShort() & 0xFFFF;
        if (numEntries != totalNumEntries || diskNumber != 0 || diskWithCentralDir != 0) {
            throw new ZipException("Spanned archives not supported");
        }
        if (commentLength > 0) {
            byte[] commentBytes = this.ras.readBytes(commentLength);
            this.comment = new String(commentBytes, 0, commentBytes.length, StandardCharsets.UTF_8);
        }
        RASlice slice = this.ras.slice(centralDirOffset, centralDirOffset + centralDirSize);
        byte[] hdrBuf = new byte[46];
        for (int i = 0; i < numEntries; ++i) {
            ZipEntry newEntry = new ZipEntry(hdrBuf, slice.createInputStream());
            if (newEntry.localHeaderRelOffset >= centralDirOffset) {
                throw new ZipException("Local file header offset is after central directory");
            }
            String entryName = newEntry.getName();
            if (this.entries.put(entryName, newEntry) == null) continue;
            throw new ZipException("Duplicate entry name: " + entryName);
        }
    }

    static void throwZipException(String msg, int magic) throws ZipException {
        throw new ZipException(msg + " signature not found; was " + magic);
    }
}

