/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarInputStream
extends ZipInputStream {
    private Manifest manifest;
    private boolean eos = false;
    private JarEntry mEntry;
    private JarEntry jarEntry;
    private boolean isMeta;
    private OutputStream verStream;

    public JarInputStream(InputStream stream, boolean verify) throws IOException {
        super(stream);
        if (verify) {
            // empty if block
        }
        if ((this.mEntry = this.getNextJarEntry()) == null) {
            return;
        }
        if (this.mEntry.getName().equalsIgnoreCase("META-INF/")) {
            this.mEntry = null;
            this.closeEntry();
            this.mEntry = this.getNextJarEntry();
        }
        if (this.mEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            this.mEntry = null;
            this.manifest = new Manifest(this, verify);
            this.closeEntry();
        } else {
            Attributes temp = new Attributes(3);
            temp.map.put("hidden", null);
            this.mEntry.setAttributes(temp);
        }
    }

    public JarInputStream(InputStream stream) throws IOException {
        this(stream, true);
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public JarEntry getNextJarEntry() throws IOException {
        return (JarEntry)this.getNextEntry();
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        if (this.mEntry != null) {
            return -1;
        }
        int r = super.read(buffer, byteOffset, byteCount);
        if (this.verStream != null && !this.eos) {
            if (r == -1) {
                this.eos = true;
            } else {
                this.verStream.write(buffer, byteOffset, r);
            }
        }
        return r;
    }

    @Override
    public ZipEntry getNextEntry() throws IOException {
        if (this.mEntry != null) {
            this.jarEntry = this.mEntry;
            this.mEntry = null;
            this.jarEntry.setAttributes(null);
        } else {
            this.jarEntry = (JarEntry)super.getNextEntry();
            if (this.jarEntry == null) {
                return null;
            }
        }
        this.eos = false;
        return this.jarEntry;
    }

    @Override
    protected ZipEntry createZipEntry(String name) {
        JarEntry entry = new JarEntry(name);
        if (this.manifest != null) {
            entry.setAttributes(this.manifest.getAttributes(name));
        }
        return entry;
    }
}

