/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.jtransc.io.JTranscIoTools;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    static final String META_DIR = "META-INF/";
    private Manifest manifest;
    private ZipEntry manifestEntry;
    private boolean closed = false;

    public JarFile(File file) throws IOException {
        this(file, true);
    }

    public JarFile(File file, boolean verify) throws IOException {
        super(file);
        if (verify) {
            // empty if block
        }
        this.readMetaEntries();
    }

    public JarFile(File file, boolean verify, int mode) throws IOException {
        super(file, mode);
        if (verify) {
            // empty if block
        }
        this.readMetaEntries();
    }

    public JarFile(String filename) throws IOException {
        this(filename, true);
    }

    public JarFile(String filename, boolean verify) throws IOException {
        super(filename);
        if (verify) {
            // empty if block
        }
        this.readMetaEntries();
    }

    public Enumeration<JarEntry> entries() {
        class JarFileEnumerator
        implements Enumeration<JarEntry> {
            Enumeration<? extends ZipEntry> ze;
            JarFile jf;

            JarFileEnumerator(Enumeration<? extends ZipEntry> zenum, JarFile jf) {
                this.ze = zenum;
                this.jf = jf;
            }

            @Override
            public boolean hasMoreElements() {
                return this.ze.hasMoreElements();
            }

            @Override
            public JarEntry nextElement() {
                JarEntry je = new JarEntry(this.ze.nextElement());
                je.parentJar = this.jf;
                return je;
            }
        }
        return new JarFileEnumerator(super.entries(), this);
    }

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    public Manifest getManifest() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("JarFile has been closed");
        }
        if (this.manifest != null) {
            return this.manifest;
        }
        try {
            try (InputStream is = super.getInputStream(this.manifestEntry);){
                this.manifest = new Manifest(is, false);
            }
            this.manifestEntry = null;
        }
        catch (NullPointerException e) {
            this.manifestEntry = null;
        }
        return this.manifest;
    }

    private void readMetaEntries() throws IOException {
        ZipEntry[] metaEntries = this.getMetaEntriesImpl();
        if (metaEntries == null) {
            return;
        }
        boolean signed = false;
        for (ZipEntry entry : metaEntries) {
            String entryName = entry.getName();
            if (this.manifestEntry != null || !entryName.equalsIgnoreCase(MANIFEST_NAME)) continue;
            this.manifestEntry = entry;
            break;
        }
    }

    private static boolean endsWithIgnoreCase(String s, String suffix) {
        return s.regionMatches(true, s.length() - suffix.length(), suffix, 0, suffix.length());
    }

    @Override
    public InputStream getInputStream(ZipEntry ze) throws IOException {
        InputStream in;
        if (this.manifestEntry != null) {
            this.getManifest();
        }
        if ((in = super.getInputStream(ze)) == null) {
            return null;
        }
        if (ze.getSize() == -1L) {
            return in;
        }
        return new JarFileInputStream(in, ze);
    }

    @Override
    public ZipEntry getEntry(String name) {
        ZipEntry ze = super.getEntry(name);
        if (ze == null) {
            return ze;
        }
        JarEntry je = new JarEntry(ze);
        je.parentJar = this;
        return je;
    }

    private ZipEntry[] getMetaEntriesImpl() {
        ArrayList<ZipEntry> list = new ArrayList<ZipEntry>(8);
        Enumeration<JarEntry> allEntries = this.entries();
        while (allEntries.hasMoreElements()) {
            ZipEntry ze = allEntries.nextElement();
            if (!ze.getName().startsWith(META_DIR) || ze.getName().length() <= META_DIR.length()) continue;
            list.add(ze);
        }
        if (list.size() == 0) {
            return null;
        }
        ZipEntry[] result = new ZipEntry[list.size()];
        list.toArray(result);
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    static final class JarFileInputStream
    extends FilterInputStream {
        private long count;
        private ZipEntry zipEntry;
        private boolean done = false;

        JarFileInputStream(InputStream is, ZipEntry ze) {
            super(is);
            this.zipEntry = ze;
            this.count = this.zipEntry.getSize();
        }

        @Override
        public int read() throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read();
                this.count = r != -1 ? --this.count : 0L;
                if (this.count == 0L) {
                    this.done = true;
                }
                return r;
            }
            this.done = true;
            return -1;
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read(buffer, byteOffset, byteCount);
                if (r != -1) {
                    int size = r;
                    if (this.count < (long)size) {
                        size = (int)this.count;
                    }
                    this.count -= (long)size;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                }
                return r;
            }
            this.done = true;
            return -1;
        }

        @Override
        public int available() throws IOException {
            if (this.done) {
                return 0;
            }
            return super.available();
        }

        @Override
        public long skip(long byteCount) throws IOException {
            return JTranscIoTools.skipByReading((InputStream)this, (long)byteCount);
        }
    }
}

