/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarEntry
extends ZipEntry {
    private Attributes attributes;
    JarFile parentJar;
    CodeSigner[] signers;
    private boolean isFactoryChecked = false;

    public JarEntry(String name) {
        super(name);
    }

    public JarEntry(ZipEntry entry) {
        super(entry);
    }

    public Attributes getAttributes() throws IOException {
        if (this.attributes != null || this.parentJar == null) {
            return this.attributes;
        }
        Manifest manifest = this.parentJar.getManifest();
        if (manifest == null) {
            return null;
        }
        this.attributes = manifest.getAttributes(this.getName());
        return this.attributes;
    }

    public Certificate[] getCertificates() {
        return new Certificate[0];
    }

    void setAttributes(Attributes attrib) {
        this.attributes = attrib;
    }

    public JarEntry(JarEntry je) {
        super(je);
        this.parentJar = je.parentJar;
        this.attributes = je.attributes;
        this.signers = je.signers;
    }

    public CodeSigner[] getCodeSigners() {
        if (this.signers == null) {
            this.signers = this.getCodeSigners(this.getCertificates());
        }
        if (this.signers == null) {
            return null;
        }
        CodeSigner[] tmp = new CodeSigner[this.signers.length];
        System.arraycopy(this.signers, 0, tmp, 0, tmp.length);
        return tmp;
    }

    private CodeSigner[] getCodeSigners(Certificate[] certs) {
        return new CodeSigner[0];
    }

    private void addCodeSigner(ArrayList<CodeSigner> asigners, List<Certificate> list) {
    }
}

