/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import com.jtransc.ds.FastStringMap;
import com.jtransc.internal.JTranscGenericCharset;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;

public abstract class Charset
implements Comparable<Charset> {
    private static FastStringMap<Charset> charsets = null;
    private static Charset _default;
    private String canonicalName;
    private Set<String> aliases;

    public static boolean isSupported(String charsetName) {
        try {
            Charset.forName(charsetName);
            return true;
        }
        catch (UnsupportedCharsetException e) {
            return false;
        }
    }

    public static native SortedMap<String, Charset> availableCharsets();

    public static Charset forName(String charsetName) {
        charsetName = charsetName.toUpperCase();
        if (charsets == null) {
            charsets = new FastStringMap();
            charsets.set("UTF-8", (Object)new JTranscGenericCharset("UTF-8", new String[0]){

                public CharsetDecoder newDecoder() {
                    return new CharsetDecoder((Charset)((Object)this), 1.0f, 4.0f){
                        int c;
                        boolean readC;
                        {
                            super(charset, averageCharsPerByte, maxCharsPerByte);
                            this.readC = false;
                        }

                        @Override
                        protected CoderResult implFlush(CharBuffer out) {
                            this.readC = false;
                            return super.implFlush(out);
                        }

                        @Override
                        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                            while (in.hasRemaining() && out.hasRemaining()) {
                                if (!this.readC) {
                                    this.c = in.get() & 0xFF;
                                    this.readC = true;
                                }
                                switch (this.c >> 4) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: {
                                        out.put((char)this.c);
                                        this.readC = false;
                                        break;
                                    }
                                    case 12: 
                                    case 13: {
                                        if (in.remaining() < 1) {
                                            return CoderResult.OVERFLOW;
                                        }
                                        out.put((char)((this.c & 0x1F) << 6 | in.get() & 0x3F));
                                        this.readC = false;
                                        break;
                                    }
                                    case 14: {
                                        if (in.remaining() < 2) {
                                            return CoderResult.OVERFLOW;
                                        }
                                        out.put((char)((this.c & 0xF) << 12 | (in.get() & 0x3F) << 6 | (in.get() & 0x3F) << 0));
                                        this.readC = false;
                                    }
                                }
                            }
                            this.readC = false;
                            if (in.hasRemaining() && !out.hasRemaining()) {
                                return CoderResult.OVERFLOW;
                            }
                            return CoderResult.UNDERFLOW;
                        }
                    };
                }
            });
            charsets.set("ISO-8859-1", (Object)new JTranscGenericCharset("ISO-8859-1", new String[0]));
            charsets.set("UTF-16", (Object)new JTranscGenericCharset("UTF-16", new String[0]));
            charsets.set("UTF-16LE", (Object)new JTranscGenericCharset("UTF-16LE", new String[0]));
            charsets.set("UTF-16BE", (Object)new JTranscGenericCharset("UTF-16BE", new String[0]));
            charsets.set("US-ASCII", (Object)new JTranscGenericCharset("US-ASCII", new String[0]));
        }
        if (charsets.has(charsetName)) {
            return (Charset)charsets.get(charsetName);
        }
        throw new UnsupportedCharsetException(charsetName);
    }

    public static Charset defaultCharset() {
        if (_default == null) {
            _default = Charset.forName("UTF-8");
        }
        return _default;
    }

    protected Charset(String canonicalName, String[] aliases) {
        this.canonicalName = canonicalName;
        this.aliases = new HashSet<String>();
        for (int n = 0; n < aliases.length; ++n) {
            this.aliases.add(aliases[n]);
        }
    }

    public final String name() {
        return this.canonicalName;
    }

    public final Set<String> aliases() {
        return this.aliases;
    }

    public String displayName() {
        return this.canonicalName;
    }

    public final boolean isRegistered() {
        return true;
    }

    public String displayName(Locale locale) {
        return this.canonicalName;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final CharBuffer decode(ByteBuffer bb) {
        try {
            byte[] data = new byte[bb.limit()];
            for (int n = 0; n < data.length; ++n) {
                data[n] = bb.get(n);
            }
            return CharBuffer.wrap(new String(data, this.canonicalName));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public final ByteBuffer encode(CharBuffer cb) {
        try {
            char[] data = new char[cb.limit()];
            for (int n = 0; n < data.length; ++n) {
                data[n] = cb.get(n);
            }
            return ByteBuffer.wrap(new String(data).getBytes(this.canonicalName));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public final ByteBuffer encode(String str) {
        return this.encode(CharBuffer.wrap(str));
    }

    public final int hashCode() {
        return this.displayName().hashCode();
    }

    @Override
    public final native int compareTo(Charset var1);

    public final native boolean equals(Object var1);

    public final String toString() {
        return this.displayName();
    }
}

