/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.AllPermission;
import java.security.Permission;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class URLConnection {
    protected URL url;
    private String contentType;
    private static boolean defaultAllowUserInteraction;
    private static boolean defaultUseCaches;
    ContentHandler defaultHandler = new DefaultContentHandler();
    private long lastModified = -1L;
    protected long ifModifiedSince;
    protected boolean useCaches = defaultUseCaches;
    protected boolean connected;
    protected boolean doOutput;
    protected boolean doInput = true;
    protected boolean allowUserInteraction = defaultAllowUserInteraction;
    private static ContentHandlerFactory contentHandlerFactory;
    private int readTimeout = 0;
    private int connectTimeout = 0;
    static Hashtable<String, Object> contentHandlers;
    private static FileNameMap fileNameMap;

    protected URLConnection(URL url) {
        this.url = url;
    }

    public abstract void connect() throws IOException;

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if ((this.contentType = this.getContentType()) == null && (this.contentType = URLConnection.guessContentTypeFromName(this.url.getFile())) == null) {
            this.contentType = URLConnection.guessContentTypeFromStream(this.getInputStream());
        }
        if (this.contentType != null) {
            return this.getContentHandler(this.contentType).getContent(this);
        }
        return null;
    }

    public Object getContent(Class[] types) throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if ((this.contentType = this.getContentType()) == null && (this.contentType = URLConnection.guessContentTypeFromName(this.url.getFile())) == null) {
            this.contentType = URLConnection.guessContentTypeFromStream(this.getInputStream());
        }
        if (this.contentType != null) {
            return this.getContentHandler(this.contentType).getContent(this, types);
        }
        return null;
    }

    public String getContentEncoding() {
        return this.getHeaderField("Content-Encoding");
    }

    private ContentHandler getContentHandler(String type) throws IOException {
        String typeString = this.parseTypeString(type.replace('/', '.'));
        Object cHandler = contentHandlers.get(type);
        if (cHandler != null) {
            return (ContentHandler)cHandler;
        }
        if (contentHandlerFactory != null) {
            cHandler = contentHandlerFactory.createContentHandler(type);
            contentHandlers.put(type, cHandler);
            return (ContentHandler)cHandler;
        }
        if (cHandler == null) {
            try {
                String className = "org.apache.harmony.awt.www.content." + typeString;
                cHandler = Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        if (cHandler != null) {
            if (!(cHandler instanceof ContentHandler)) {
                throw new UnknownServiceException();
            }
            contentHandlers.put(type, cHandler);
            return (ContentHandler)cHandler;
        }
        return this.defaultHandler;
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("Content-Length", -1);
    }

    public long getContentLengthLong() {
        return this.getHeaderFieldLong("Content-Length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public long getDate() {
        return this.getHeaderFieldDate("Date", 0L);
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    @Deprecated
    public static String getDefaultRequestProperty(String field) {
        return null;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("Expires", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileNameMap getFileNameMap() {
        Class<URLConnection> clazz = URLConnection.class;
        synchronized (URLConnection.class) {
            if (fileNameMap == null) {
                fileNameMap = new FileNameMap(){

                    @Override
                    public String getContentTypeFor(String filename) {
                        return "application/octet-stream";
                    }
                };
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fileNameMap;
        }
    }

    public String getHeaderField(int pos) {
        return null;
    }

    public Map<String, List<String>> getHeaderFields() {
        return Collections.emptyMap();
    }

    public Map<String, List<String>> getRequestProperties() {
        this.checkNotConnected();
        return Collections.emptyMap();
    }

    private void checkNotConnected() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
    }

    public void addRequestProperty(String field, String newValue) {
        this.checkNotConnected();
        if (field == null) {
            throw new NullPointerException("field == null");
        }
    }

    public String getHeaderField(String key) {
        return null;
    }

    public long getHeaderFieldDate(String field, long defaultValue) {
        String date = this.getHeaderField(field);
        if (date == null) {
            return defaultValue;
        }
        try {
            return Date.parse(date);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getHeaderFieldInt(String field, int defaultValue) {
        try {
            return Integer.parseInt(this.getHeaderField(field));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getHeaderFieldLong(String field, int defaultValue) {
        try {
            return Long.parseLong(this.getHeaderField(field));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getHeaderFieldKey(int posn) {
        return null;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException("Does not support writing to the input stream");
    }

    public long getLastModified() {
        if (this.lastModified != -1L) {
            return this.lastModified;
        }
        this.lastModified = this.getHeaderFieldDate("Last-Modified", 0L);
        return this.lastModified;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("Does not support writing to the output stream");
    }

    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    public String getRequestProperty(String field) {
        this.checkNotConnected();
        return null;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public static String guessContentTypeFromName(String url) {
        return URLConnection.getFileNameMap().getContentTypeFor(url);
    }

    public static String guessContentTypeFromStream(InputStream is) throws IOException {
        String header;
        if (!is.markSupported()) {
            return null;
        }
        is.mark(64);
        byte[] bytes = new byte[64];
        int length = is.read(bytes);
        is.reset();
        if (length == -1) {
            return null;
        }
        String encoding = "US-ASCII";
        int start = 0;
        if (length > 1) {
            if (bytes[0] == -1 && bytes[1] == -2) {
                encoding = "UTF-16LE";
                start = 2;
                length -= length & 1;
            }
            if (bytes[0] == -2 && bytes[1] == -1) {
                encoding = "UTF-16BE";
                start = 2;
                length -= length & 1;
            }
            if (length > 2) {
                if (bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                    encoding = "UTF-8";
                    start = 3;
                }
                if (length > 3) {
                    if (bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
                        encoding = "UTF-32BE";
                        start = 4;
                        length -= length & 3;
                    }
                    if (bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0) {
                        encoding = "UTF-32LE";
                        start = 4;
                        length -= length & 3;
                    }
                }
            }
        }
        if ((header = new String(bytes, start, length - start, encoding)).startsWith("PK")) {
            return "application/zip";
        }
        if (header.startsWith("GI")) {
            return "image/gif";
        }
        String textHeader = header.trim().toUpperCase(Locale.US);
        if (textHeader.startsWith("<!DOCTYPE HTML") || textHeader.startsWith("<HTML") || textHeader.startsWith("<HEAD") || textHeader.startsWith("<BODY") || textHeader.startsWith("<HEAD")) {
            return "text/html";
        }
        if (textHeader.startsWith("<?XML")) {
            return "application/xml";
        }
        return null;
    }

    private String parseTypeString(String typeString) {
        StringBuilder result = new StringBuilder(typeString);
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '.') continue;
            result.setCharAt(i, '_');
        }
        return result.toString();
    }

    public void setAllowUserInteraction(boolean newValue) {
        this.checkNotConnected();
        this.allowUserInteraction = newValue;
    }

    public static synchronized void setContentHandlerFactory(ContentHandlerFactory contentFactory) {
        if (contentHandlerFactory != null) {
            throw new Error("Factory already set");
        }
        contentHandlerFactory = contentFactory;
    }

    public static void setDefaultAllowUserInteraction(boolean allows) {
        defaultAllowUserInteraction = allows;
    }

    @Deprecated
    public static void setDefaultRequestProperty(String field, String value) {
    }

    public void setDefaultUseCaches(boolean newValue) {
        defaultUseCaches = newValue;
    }

    public void setDoInput(boolean newValue) {
        this.checkNotConnected();
        this.doInput = newValue;
    }

    public void setDoOutput(boolean newValue) {
        this.checkNotConnected();
        this.doOutput = newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileNameMap(FileNameMap map) {
        Class<URLConnection> clazz = URLConnection.class;
        synchronized (URLConnection.class) {
            fileNameMap = map;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setIfModifiedSince(long newValue) {
        this.checkNotConnected();
        this.ifModifiedSince = newValue;
    }

    public void setRequestProperty(String field, String newValue) {
        this.checkNotConnected();
        if (field == null) {
            throw new NullPointerException("field == null");
        }
    }

    public void setUseCaches(boolean newValue) {
        this.checkNotConnected();
        this.useCaches = newValue;
    }

    public void setConnectTimeout(int timeoutMillis) {
        if (timeoutMillis < 0) {
            throw new IllegalArgumentException("timeoutMillis < 0");
        }
        this.connectTimeout = timeoutMillis;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeoutMillis) {
        if (timeoutMillis < 0) {
            throw new IllegalArgumentException("timeoutMillis < 0");
        }
        this.readTimeout = timeoutMillis;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.url.toString();
    }

    public native long getHeaderFieldLong(String var1, long var2);

    static {
        defaultUseCaches = true;
        contentHandlers = new Hashtable();
    }

    static class DefaultContentHandler
    extends ContentHandler {
        DefaultContentHandler() {
        }

        @Override
        public Object getContent(URLConnection u) throws IOException {
            return u.getInputStream();
        }
    }
}

