/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscSystemProperties;
import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.JTranscFileSystem;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;

public class File
implements Serializable,
Comparable<File> {
    private static final FileSystem fs = new JTranscFileSystem();
    private final String path;
    private transient PathStatus status = null;
    private final transient int prefixLength;
    public static final char separatorChar = fs.getSeparator();
    public static final String separator = "" + separatorChar;
    public static final char pathSeparatorChar = fs.getPathSeparator();
    public static final String pathSeparator = "" + pathSeparatorChar;

    final boolean isInvalid() {
        if (this.status == null) {
            this.status = this.path.indexOf(0) < 0 ? PathStatus.CHECKED : PathStatus.INVALID;
        }
        return this.status == PathStatus.INVALID;
    }

    int getPrefixLength() {
        return this.prefixLength;
    }

    private File(String pathname, int prefixLength) {
        this.path = pathname;
        this.prefixLength = prefixLength;
    }

    private File(String child, File parent) {
        assert (parent.path != null);
        assert (!parent.path.equals(""));
        this.path = fs.resolve(parent.path, child);
        this.prefixLength = parent.prefixLength;
    }

    public File(String pathname) {
        if (pathname == null) {
            throw new NullPointerException();
        }
        this.path = fs.normalize(pathname);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(String parent, String child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.path = parent != null ? fs.resolve(parent.equals("") ? fs.getDefaultParent() : fs.normalize(parent), fs.normalize(child)) : fs.normalize(child);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(File parent, String child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.path = parent != null ? fs.resolve(parent.path.equals("") ? fs.getDefaultParent() : parent.path, fs.normalize(child)) : fs.normalize(child);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uri.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uri.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String p = uri.getPath();
        if (p.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        p = fs.fromURIPath(p);
        if (separatorChar != '/') {
            p = p.replace('/', separatorChar);
        }
        this.path = fs.normalize(p);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public String getName() {
        int index = this.path.lastIndexOf(separatorChar);
        if (index < this.prefixLength) {
            return this.path.substring(this.prefixLength);
        }
        return this.path.substring(index + 1);
    }

    public String getParent() {
        int index = this.path.lastIndexOf(separatorChar);
        if (index < this.prefixLength) {
            if (this.prefixLength > 0 && this.path.length() > this.prefixLength) {
                return this.path.substring(0, this.prefixLength);
            }
            return null;
        }
        return this.path.substring(0, index);
    }

    public File getParentFile() {
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        return new File(p, this.prefixLength);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return fs.isAbsolute(this);
    }

    public String getAbsolutePath() {
        return fs.resolve(this);
    }

    public File getAbsoluteFile() {
        String absPath = this.getAbsolutePath();
        return new File(absPath, fs.prefixLength(absPath));
    }

    public String getCanonicalPath() throws IOException {
        if (this.isInvalid()) {
            throw new IOException("Invalid file path");
        }
        return fs.canonicalize(fs.resolve(this));
    }

    public File getCanonicalFile() throws IOException {
        String canonPath = this.getCanonicalPath();
        return new File(canonPath, fs.prefixLength(canonPath));
    }

    private static String slashify(String path, boolean isDirectory) {
        String p = path;
        if (separatorChar != '/') {
            p = p.replace(separatorChar, '/');
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.endsWith("/") && isDirectory) {
            p = p + "/";
        }
        return p;
    }

    @Deprecated
    public URL toURL() throws MalformedURLException {
        if (this.isInvalid()) {
            throw new MalformedURLException("Invalid file path");
        }
        return new URL("file", "", File.slashify(this.getAbsolutePath(), this.isDirectory()));
    }

    public URI toURI() {
        try {
            File f = this.getAbsoluteFile();
            String sp = File.slashify(f.getPath(), f.isDirectory());
            if (sp.startsWith("//")) {
                sp = "//" + sp;
            }
            return new URI("file", null, sp, null);
        }
        catch (URISyntaxException x) {
            throw new Error(x);
        }
    }

    public boolean canRead() {
        if (this.isInvalid()) {
            return false;
        }
        return fs.checkAccess(this, 4);
    }

    public boolean canWrite() {
        if (this.isInvalid()) {
            return false;
        }
        return fs.checkAccess(this, 2);
    }

    public boolean exists() {
        if (this.isInvalid()) {
            return false;
        }
        return (fs.getBooleanAttributes(this) & 1) != 0;
    }

    public boolean isDirectory() {
        if (this.isInvalid()) {
            return false;
        }
        return (fs.getBooleanAttributes(this) & 4) != 0;
    }

    public boolean isFile() {
        if (this.isInvalid()) {
            return false;
        }
        return (fs.getBooleanAttributes(this) & 2) != 0;
    }

    public boolean isHidden() {
        if (this.isInvalid()) {
            return false;
        }
        return (fs.getBooleanAttributes(this) & 8) != 0;
    }

    public long lastModified() {
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getLastModifiedTime(this);
    }

    public long length() {
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getLength(this);
    }

    public boolean createNewFile() throws IOException {
        if (this.isInvalid()) {
            throw new IOException("Invalid file path");
        }
        return fs.createFileExclusively(this.path);
    }

    public boolean delete() {
        if (this.isInvalid()) {
            return false;
        }
        return fs.delete(this);
    }

    public native void deleteOnExit();

    public String[] list() {
        if (this.isInvalid()) {
            return null;
        }
        return fs.list(this);
    }

    public String[] list(FilenameFilter filter) {
        String[] names = this.list();
        if (names == null || filter == null) {
            return names;
        }
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (!filter.accept(this, names[i])) continue;
            v.add(names[i]);
        }
        return v.toArray(new String[v.size()]);
    }

    public File[] listFiles() {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        File[] fs = new File[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new File(ss[i], this);
        }
        return fs;
    }

    public File[] listFiles(FilenameFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String s : ss) {
            if (filter != null && !filter.accept(this, s)) continue;
            files.add(new File(s, this));
        }
        return files.toArray(new File[files.size()]);
    }

    public File[] listFiles(FileFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String s : ss) {
            File f = new File(s, this);
            if (filter != null && !filter.accept(f)) continue;
            files.add(f);
        }
        return files.toArray(new File[files.size()]);
    }

    public boolean mkdir() {
        if (this.isInvalid()) {
            return false;
        }
        return fs.createDirectory(this);
    }

    public boolean mkdirs() {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        File canonFile = null;
        try {
            canonFile = this.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parent = canonFile.getParentFile();
        return parent != null && (parent.mkdirs() || parent.exists()) && canonFile.mkdir();
    }

    public boolean renameTo(File dest) {
        if (dest == null) {
            throw new NullPointerException();
        }
        if (this.isInvalid() || dest.isInvalid()) {
            return false;
        }
        return fs.rename(this, dest);
    }

    public boolean setLastModified(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setLastModifiedTime(this, time);
    }

    public boolean setReadOnly() {
        if (this.isInvalid()) {
            return false;
        }
        return fs.setReadOnly(this);
    }

    public boolean setWritable(boolean writable, boolean ownerOnly) {
        if (this.isInvalid()) {
            return false;
        }
        return fs.setPermission(this, 2, writable, ownerOnly);
    }

    public boolean setWritable(boolean writable) {
        return this.setWritable(writable, true);
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) {
        if (this.isInvalid()) {
            return false;
        }
        return fs.setPermission(this, 4, readable, ownerOnly);
    }

    public boolean setReadable(boolean readable) {
        return this.setReadable(readable, true);
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        if (this.isInvalid()) {
            return false;
        }
        return fs.setPermission(this, 1, executable, ownerOnly);
    }

    public boolean setExecutable(boolean executable) {
        return this.setExecutable(executable, true);
    }

    public boolean canExecute() {
        if (this.isInvalid()) {
            return false;
        }
        return fs.checkAccess(this, 1);
    }

    public static File[] listRoots() {
        return fs.listRoots();
    }

    public long getTotalSpace() {
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getSpace(this, 0);
    }

    public long getFreeSpace() {
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getSpace(this, 1);
    }

    public long getUsableSpace() {
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getSpace(this, 2);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File f;
        File tmpdir;
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        File file = tmpdir = directory != null ? directory : TempDirectory.location();
        while ((fs.getBooleanAttributes(f = TempDirectory.generateFile(prefix, suffix, tmpdir)) & 1) != 0) {
        }
        if (!fs.createFileExclusively(f.getPath())) {
            throw new IOException("Unable to create temporary file");
        }
        return f;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }

    @Override
    public int compareTo(File pathname) {
        return fs.compare(this, pathname);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof File) {
            return this.compareTo((File)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return fs.hashCode(this);
    }

    public String toString() {
        return this.getPath();
    }

    private static class TempDirectory {
        private static final File tmpdir = new File(JTranscSystemProperties.tmpdir());

        private TempDirectory() {
        }

        static File location() {
            return tmpdir;
        }

        static native File generateFile(String var0, String var1, File var2) throws IOException;
    }

    private static enum PathStatus {
        INVALID,
        CHECKED;

    }
}

