/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ObjectStreamField;

class EmulatedFields {
    private ObjectSlot[] slotsToSerialize;
    private ObjectStreamField[] declaredFields;

    public EmulatedFields(ObjectStreamField[] fields, ObjectStreamField[] declared) {
        this.buildSlots(fields);
        this.declaredFields = declared;
    }

    private void buildSlots(ObjectStreamField[] fields) {
        this.slotsToSerialize = new ObjectSlot[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ObjectSlot s;
            this.slotsToSerialize[i] = s = new ObjectSlot();
            s.field = fields[i];
        }
    }

    public boolean defaulted(String name) throws IllegalArgumentException {
        ObjectSlot slot = this.findSlot(name, null);
        if (slot == null) {
            throw new IllegalArgumentException("no field '" + name + "'");
        }
        return slot.defaulted;
    }

    private ObjectSlot findSlot(String fieldName, Class<?> fieldType) {
        int i;
        boolean isPrimitive = fieldType != null && fieldType.isPrimitive();
        for (i = 0; i < this.slotsToSerialize.length; ++i) {
            ObjectSlot slot = this.slotsToSerialize[i];
            if (!slot.field.getName().equals(fieldName)) continue;
            if (isPrimitive) {
                if (slot.field.getType() != fieldType) continue;
                return slot;
            }
            if (fieldType == null) {
                return slot;
            }
            if (!slot.field.getType().isAssignableFrom(fieldType)) continue;
            return slot;
        }
        if (this.declaredFields != null) {
            for (i = 0; i < this.declaredFields.length; ++i) {
                ObjectStreamField field = this.declaredFields[i];
                if (!field.getName().equals(fieldName) || !(isPrimitive ? fieldType == field.getType() : fieldType == null || field.getType().isAssignableFrom(fieldType))) continue;
                ObjectSlot slot = new ObjectSlot();
                slot.field = field;
                slot.defaulted = true;
                return slot;
            }
        }
        return null;
    }

    private ObjectSlot findMandatorySlot(String name, Class<?> type) {
        ObjectSlot slot = this.findSlot(name, type);
        if (slot == null || type == null && slot.field.getType().isPrimitive()) {
            throw new IllegalArgumentException("no field '" + name + "' of type " + type);
        }
        return slot;
    }

    public byte get(String name, byte defaultValue) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Byte.TYPE);
        return slot.defaulted ? defaultValue : (Byte)slot.fieldValue;
    }

    public char get(String name, char defaultValue) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Character.TYPE);
        return slot.defaulted ? defaultValue : ((Character)slot.fieldValue).charValue();
    }

    public double get(String name, double defaultValue) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Double.TYPE);
        return slot.defaulted ? defaultValue : (Double)slot.fieldValue;
    }

    public float get(String name, float defaultValue) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Float.TYPE);
        return slot.defaulted ? defaultValue : ((Float)slot.fieldValue).floatValue();
    }

    public int get(String name, int defaultValue) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Integer.TYPE);
        return slot.defaulted ? defaultValue : (Integer)slot.fieldValue;
    }

    public long get(String name, long defaultValue) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Long.TYPE);
        return slot.defaulted ? defaultValue : (Long)slot.fieldValue;
    }

    public Object get(String name, Object defaultValue) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, null);
        return slot.defaulted ? defaultValue : slot.fieldValue;
    }

    public short get(String name, short defaultValue) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Short.TYPE);
        return slot.defaulted ? defaultValue : (Short)slot.fieldValue;
    }

    public boolean get(String name, boolean defaultValue) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Boolean.TYPE);
        return slot.defaulted ? defaultValue : (Boolean)slot.fieldValue;
    }

    public void put(String name, byte value) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Byte.TYPE);
        slot.fieldValue = value;
        slot.defaulted = false;
    }

    public void put(String name, char value) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Character.TYPE);
        slot.fieldValue = Character.valueOf(value);
        slot.defaulted = false;
    }

    public void put(String name, double value) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Double.TYPE);
        slot.fieldValue = value;
        slot.defaulted = false;
    }

    public void put(String name, float value) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Float.TYPE);
        slot.fieldValue = Float.valueOf(value);
        slot.defaulted = false;
    }

    public void put(String name, int value) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Integer.TYPE);
        slot.fieldValue = value;
        slot.defaulted = false;
    }

    public void put(String name, long value) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Long.TYPE);
        slot.fieldValue = value;
        slot.defaulted = false;
    }

    public void put(String name, Object value) throws IllegalArgumentException {
        Class<?> valueClass = null;
        if (value != null) {
            valueClass = value.getClass();
        }
        ObjectSlot slot = this.findMandatorySlot(name, valueClass);
        slot.fieldValue = value;
        slot.defaulted = false;
    }

    public void put(String name, short value) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Short.TYPE);
        slot.fieldValue = value;
        slot.defaulted = false;
    }

    public void put(String name, boolean value) throws IllegalArgumentException {
        ObjectSlot slot = this.findMandatorySlot(name, Boolean.TYPE);
        slot.fieldValue = value;
        slot.defaulted = false;
    }

    public ObjectSlot[] slots() {
        return this.slotsToSerialize;
    }

    static class ObjectSlot {
        ObjectStreamField field;
        Object fieldValue;
        boolean defaulted = true;

        ObjectSlot() {
        }

        public ObjectStreamField getField() {
            return this.field;
        }

        public Object getFieldValue() {
            return this.fieldValue;
        }
    }
}

