/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscBits;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    private final byte[] scratch = new byte[8];
    protected int written;

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    public final int size() {
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
        return this.written;
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("buffer == null");
        }
        this.out.write(buffer, offset, count);
        this.written += count;
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.out.write(oneByte);
        ++this.written;
    }

    @Override
    public final void writeBoolean(boolean val) throws IOException {
        this.out.write(val ? 1 : 0);
        ++this.written;
    }

    @Override
    public final void writeByte(int val) throws IOException {
        this.out.write(val);
        ++this.written;
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        if (str.length() == 0) {
            return;
        }
        byte[] bytes = new byte[str.length()];
        for (int index = 0; index < str.length(); ++index) {
            bytes[index] = (byte)str.charAt(index);
        }
        this.out.write(bytes);
        this.written += bytes.length;
    }

    @Override
    public final void writeChar(int val) throws IOException {
        this.writeShort(val);
    }

    @Override
    public final void writeChars(String str) throws IOException {
        byte[] bytes = str.getBytes("UTF-16BE");
        this.out.write(bytes);
        this.written += bytes.length;
    }

    @Override
    public final void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    @Override
    public final void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    @Override
    public final void writeInt(int val) throws IOException {
        JTranscBits.writeIntBE((byte[])this.scratch, (int)0, (int)val);
        this.out.write(this.scratch, 0, 4);
        this.written += 4;
    }

    @Override
    public final void writeLong(long val) throws IOException {
        JTranscBits.writeLongBE((byte[])this.scratch, (int)0, (long)val);
        this.out.write(this.scratch, 0, 8);
        this.written += 8;
    }

    @Override
    public final void writeShort(int val) throws IOException {
        JTranscBits.writeShortBE((byte[])this.scratch, (int)0, (short)((short)val));
        this.out.write(this.scratch, 0, 2);
        this.written += 2;
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.write(str.getBytes(StandardCharsets.UTF_8));
    }
}

