/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscArrays;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    protected volatile byte[] buf;
    protected int count;
    protected int marklimit;
    protected int markpos = -1;
    protected int pos;

    public BufferedInputStream(InputStream in) {
        this(in, 8192);
    }

    public BufferedInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[size];
    }

    @Override
    public synchronized int available() throws IOException {
        InputStream localIn = this.in;
        if (this.buf == null || localIn == null) {
            throw this.streamClosed();
        }
        return this.count - this.pos + localIn.available();
    }

    private IOException streamClosed() throws IOException {
        throw new IOException("BufferedInputStream is closed");
    }

    @Override
    public void close() throws IOException {
        this.buf = null;
        InputStream localIn = this.in;
        this.in = null;
        if (localIn != null) {
            localIn.close();
        }
    }

    private int fillbuf(InputStream localIn, byte[] localBuf) throws IOException {
        if (this.markpos == -1 || this.pos - this.markpos >= this.marklimit) {
            int result = localIn.read(localBuf);
            if (result > 0) {
                this.markpos = -1;
                this.pos = 0;
                this.count = result == -1 ? 0 : result;
            }
            return result;
        }
        if (this.markpos == 0 && this.marklimit > localBuf.length) {
            int newLength = localBuf.length * 2;
            if (newLength > this.marklimit) {
                newLength = this.marklimit;
            }
            byte[] newbuf = new byte[newLength];
            System.arraycopy(localBuf, 0, newbuf, 0, localBuf.length);
            this.buf = newbuf;
            localBuf = newbuf;
        } else if (this.markpos > 0) {
            System.arraycopy(localBuf, this.markpos, localBuf, 0, localBuf.length - this.markpos);
        }
        this.pos -= this.markpos;
        this.markpos = 0;
        this.count = 0;
        int bytesread = localIn.read(localBuf, this.pos, localBuf.length - this.pos);
        this.count = bytesread <= 0 ? this.pos : this.pos + bytesread;
        return bytesread;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] localBuf = this.buf;
        InputStream localIn = this.in;
        if (localBuf == null || localIn == null) {
            throw this.streamClosed();
        }
        if (this.pos >= this.count && this.fillbuf(localIn, localBuf) == -1) {
            return -1;
        }
        if (localBuf != this.buf && (localBuf = this.buf) == null) {
            throw this.streamClosed();
        }
        if (this.count - this.pos > 0) {
            return localBuf[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int required;
        byte[] localBuf = this.buf;
        if (localBuf == null) {
            throw this.streamClosed();
        }
        JTranscArrays.checkOffsetAndCount((int)buffer.length, (int)byteOffset, (int)byteCount);
        if (byteCount == 0) {
            return 0;
        }
        InputStream localIn = this.in;
        if (localIn == null) {
            throw this.streamClosed();
        }
        if (this.pos < this.count) {
            int copylength = this.count - this.pos >= byteCount ? byteCount : this.count - this.pos;
            System.arraycopy(localBuf, this.pos, buffer, byteOffset, copylength);
            this.pos += copylength;
            if (copylength == byteCount || localIn.available() == 0) {
                return copylength;
            }
            byteOffset += copylength;
            required = byteCount - copylength;
        } else {
            required = byteCount;
        }
        while (true) {
            int read;
            if (this.markpos == -1 && required >= localBuf.length) {
                read = localIn.read(buffer, byteOffset, required);
                if (read == -1) {
                    return required == byteCount ? -1 : byteCount - required;
                }
            } else {
                if (this.fillbuf(localIn, localBuf) == -1) {
                    return required == byteCount ? -1 : byteCount - required;
                }
                if (localBuf != this.buf && (localBuf = this.buf) == null) {
                    throw this.streamClosed();
                }
                read = this.count - this.pos >= required ? required : this.count - this.pos;
                System.arraycopy(localBuf, this.pos, buffer, byteOffset, read);
                this.pos += read;
            }
            if ((required -= read) == 0) {
                return byteCount;
            }
            if (localIn.available() == 0) {
                return byteCount - required;
            }
            byteOffset += read;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        if (-1 == this.markpos) {
            throw new IOException("Mark has been invalidated.");
        }
        this.pos = this.markpos;
    }

    @Override
    public synchronized long skip(long byteCount) throws IOException {
        byte[] localBuf = this.buf;
        InputStream localIn = this.in;
        if (localBuf == null) {
            throw this.streamClosed();
        }
        if (byteCount < 1L) {
            return 0L;
        }
        if (localIn == null) {
            throw this.streamClosed();
        }
        if ((long)(this.count - this.pos) >= byteCount) {
            this.pos = (int)((long)this.pos + byteCount);
            return byteCount;
        }
        long read = this.count - this.pos;
        this.pos = this.count;
        if (this.markpos != -1 && byteCount <= (long)this.marklimit) {
            if (this.fillbuf(localIn, localBuf) == -1) {
                return read;
            }
            if ((long)(this.count - this.pos) >= byteCount - read) {
                this.pos = (int)((long)this.pos + (byteCount - read));
                return byteCount;
            }
            this.pos = this.count;
            return read += (long)(this.count - this.pos);
        }
        return read + localIn.skip(byteCount - read);
    }
}

