/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;

public class BufferedImage
extends Image {
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_INT_RGB = 1;
    public static final int TYPE_INT_ARGB = 2;
    public static final int TYPE_INT_ARGB_PRE = 3;
    public static final int TYPE_INT_BGR = 4;
    public static final int TYPE_3BYTE_BGR = 5;
    public static final int TYPE_4BYTE_ABGR = 6;
    public static final int TYPE_4BYTE_ABGR_PRE = 7;
    public static final int TYPE_USHORT_565_RGB = 8;
    public static final int TYPE_USHORT_555_RGB = 9;
    public static final int TYPE_BYTE_GRAY = 10;
    public static final int TYPE_USHORT_GRAY = 11;
    public static final int TYPE_BYTE_BINARY = 12;
    public static final int TYPE_BYTE_INDEXED = 13;
    private int imageType = 0;
    private int width;
    private int height;
    private int[] data;
    private Graphics2D graphics;

    public BufferedImage(int width, int height, int imageType) {
        this.width = width;
        this.height = height;
        this.imageType = imageType;
        this.data = new int[width * height];
    }

    private int index(int x, int y) {
        return y * this.width + x;
    }

    public int getRGB(int x, int y) {
        return this.data[this.index(x, y)];
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        if (rgbArray == null) {
            rgbArray = new int[offset + h * scansize];
        }
        for (int y = 0; y < h; ++y) {
            int n = offset + y * scansize;
            for (int x = 0; x < w; ++x) {
                rgbArray[n++] = this.getRGB(startX + x, startY + y);
            }
        }
        return rgbArray;
    }

    public synchronized void setRGB(int x, int y, int rgb) {
        this.data[this.index((int)x, (int)y)] = rgb;
    }

    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        for (int y = 0; y < h; ++y) {
            int n = offset + y * scansize;
            for (int x = 0; x < w; ++x) {
                this.setRGB(startX + x, startY + y, rgbArray[n++]);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.width;
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.height;
    }

    @Override
    public ImageProducer getSource() {
        return null;
    }

    @Override
    public Graphics getGraphics() {
        if (this.graphics == null) {
            this.graphics = new Graphics2D(){

                @Override
                public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
                    if (img instanceof BufferedImage) {
                        BufferedImage bi = (BufferedImage)img;
                        int[] rgb = bi.getRGB(0, 0, bi.getWidth(), bi.getHeight(), null, 0, bi.getWidth());
                        BufferedImage.this.setRGB(x, y, bi.getWidth(), bi.getHeight(), rgb, 0, bi.getWidth());
                    }
                    return false;
                }
            };
        }
        return this.graphics;
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        return null;
    }
}

