/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class AffineTransform {
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    private double a;
    private double b;
    private double c;
    private double d;
    private double tx;
    private double ty;
    private transient int type;

    public AffineTransform() {
        this.d = 1.0;
        this.a = 1.0;
    }

    public AffineTransform(AffineTransform that) {
        this.a = that.a;
        this.b = that.b;
        this.c = that.c;
        this.d = that.d;
        this.tx = that.tx;
        this.ty = that.ty;
        this.type = that.type;
    }

    public AffineTransform(float a, float b, float c, float d, float tx, float ty) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
    }

    public AffineTransform(float[] v) {
        this.a = v[0];
        this.b = v[1];
        this.c = v[2];
        this.d = v[3];
        if (v.length > 5) {
            this.tx = v[4];
            this.ty = v[5];
        }
    }

    public AffineTransform(double a, double b, double c, double d, double tx, double ty) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
    }

    public AffineTransform(double[] v) {
        this.a = v[0];
        this.b = v[1];
        this.c = v[2];
        this.d = v[3];
        if (v.length > 5) {
            this.tx = v[4];
            this.ty = v[5];
        }
    }

    public static native AffineTransform getTranslateInstance(double var0, double var2);

    public static native AffineTransform getRotateInstance(double var0);

    public static native AffineTransform getRotateInstance(double var0, double var2, double var4);

    public static native AffineTransform getRotateInstance(double var0, double var2);

    public static native AffineTransform getRotateInstance(double var0, double var2, double var4, double var6);

    public static native AffineTransform getQuadrantRotateInstance(int var0);

    public static native AffineTransform getQuadrantRotateInstance(int var0, double var1, double var3);

    public static native AffineTransform getScaleInstance(double var0, double var2);

    public static native AffineTransform getShearInstance(double var0, double var2);

    public int getType() {
        return 32;
    }

    public native double getDeterminant();

    public native void getMatrix(double[] var1);

    public double getScaleX() {
        return this.a;
    }

    public double getScaleY() {
        return this.d;
    }

    public double getShearX() {
        return this.c;
    }

    public double getShearY() {
        return this.b;
    }

    public double getTranslateX() {
        return this.tx;
    }

    public double getTranslateY() {
        return this.ty;
    }

    public native void translate(double var1, double var3);

    public native void rotate(double var1);

    public native void rotate(double var1, double var3, double var5);

    public native void rotate(double var1, double var3);

    public native void rotate(double var1, double var3, double var5, double var7);

    public native void quadrantRotate(int var1);

    public native void quadrantRotate(int var1, double var2, double var4);

    public native void scale(double var1, double var3);

    public native void shear(double var1, double var3);

    public native void setToIdentity();

    public native void setToTranslation(double var1, double var3);

    public native void setToRotation(double var1);

    public native void setToRotation(double var1, double var3, double var5);

    public native void setToRotation(double var1, double var3);

    public native void setToRotation(double var1, double var3, double var5, double var7);

    public native void setToQuadrantRotation(int var1);

    public native void setToQuadrantRotation(int var1, double var2, double var4);

    public native void setToScale(double var1, double var3);

    public native void setToShear(double var1, double var3);

    public native void setTransform(AffineTransform var1);

    public native void setTransform(double var1, double var3, double var5, double var7, double var9, double var11);

    public native void concatenate(AffineTransform var1);

    public native void preConcatenate(AffineTransform var1);

    public native AffineTransform createInverse() throws NoninvertibleTransformException;

    public native void invert() throws NoninvertibleTransformException;

    public native Point2D transform(Point2D var1, Point2D var2);

    public native void transform(Point2D[] var1, int var2, Point2D[] var3, int var4, int var5);

    public native void transform(float[] var1, int var2, float[] var3, int var4, int var5);

    public native void transform(double[] var1, int var2, double[] var3, int var4, int var5);

    public native void transform(float[] var1, int var2, double[] var3, int var4, int var5);

    public native void transform(double[] var1, int var2, float[] var3, int var4, int var5);

    public native Point2D inverseTransform(Point2D var1, Point2D var2) throws NoninvertibleTransformException;

    public native void inverseTransform(double[] var1, int var2, double[] var3, int var4, int var5) throws NoninvertibleTransformException;

    public native Point2D deltaTransform(Point2D var1, Point2D var2);

    public native void deltaTransform(double[] var1, int var2, double[] var3, int var4, int var5);

    public native Shape createTransformedShape(Shape var1);

    public native boolean isIdentity();

    public String toString() {
        return "AffineTransform";
    }
}

