/*
 * Decompiled with CFR 0.152.
 */
package jtransc;

import java.lang.reflect.Field;
import jtransc.annotation.JTranscInline;
import jtransc.annotation.JTranscInvisible;
import sun.misc.Unsafe;

@JTranscInvisible
public final class FastMemory {
    private static Unsafe unsafe;
    private int length;
    private byte[] data;

    public FastMemory(int size) {
        if (unsafe == null) {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                unsafe = (Unsafe)f.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.length = size;
        this.data = new byte[size + 7 & 0xFFFFFFF8];
    }

    @JTranscInline
    public final int getLength() {
        return this.length;
    }

    @JTranscInline
    public final int getAllocatedLength() {
        return this.data.length;
    }

    @JTranscInline
    public final byte getInt8(int index) {
        return unsafe.getByte(this.data, index);
    }

    @JTranscInline
    public final short getInt16(int index) {
        return unsafe.getShort(this.data, index);
    }

    @JTranscInline
    public final int getInt32(int index) {
        return unsafe.getInt(this.data, index);
    }

    @JTranscInline
    public final long getInt64(int index) {
        return unsafe.getLong(this.data, index);
    }

    @JTranscInline
    public final float getFloat32(int index) {
        return unsafe.getFloat(this.data, index);
    }

    @JTranscInline
    public final double getFloat64(int index) {
        return unsafe.getDouble(this.data, index);
    }

    @JTranscInline
    public final void setInt8(int index, byte value) {
        unsafe.putByte(this.data, index, value);
    }

    @JTranscInline
    public final void setInt16(int index, short value) {
        unsafe.putShort(this.data, index, value);
    }

    @JTranscInline
    public final void setInt32(int index, int value) {
        unsafe.putInt(this.data, index, value);
    }

    @JTranscInline
    public final void setInt64(int index, long value) {
        unsafe.putLong(this.data, index, value);
    }

    @JTranscInline
    public final void setFloat32(int index, float value) {
        unsafe.putFloat(this.data, index, value);
    }

    @JTranscInline
    public final void setFloat64(int index, double value) {
        unsafe.putDouble(this.data, index, value);
    }

    @JTranscInline
    public final byte getAlignedInt8(int index) {
        return unsafe.getByte(this.data, (long)index << 0);
    }

    @JTranscInline
    public final short getAlignedInt16(int index2) {
        return unsafe.getShort(this.data, (long)index2 << 1);
    }

    @JTranscInline
    public final int getAlignedInt32(int index4) {
        return unsafe.getInt(this.data, (long)index4 << 2);
    }

    @JTranscInline
    public final long getAlignedInt64(int index8) {
        return unsafe.getLong(this.data, (long)index8 << 3);
    }

    @JTranscInline
    public final float getAlignedFloat32(int index4) {
        return unsafe.getFloat(this.data, (long)index4 << 2);
    }

    @JTranscInline
    public final double getAlignedFloat64(int index8) {
        return unsafe.getDouble(this.data, (long)index8 << 3);
    }

    @JTranscInline
    public final void setAlignedInt8(int index, byte value) {
        unsafe.putByte(this.data, (long)index << 0, value);
    }

    @JTranscInline
    public final void setAlignedInt16(int index2, short value) {
        unsafe.putShort(this.data, (long)index2 << 1, value);
    }

    @JTranscInline
    public final void setAlignedInt32(int index4, int value) {
        unsafe.putInt(this.data, (long)index4 << 2, value);
    }

    @JTranscInline
    public final void setAlignedInt64(int index8, long value) {
        unsafe.putLong(this.data, (long)index8 << 3, value);
    }

    @JTranscInline
    public final void setAlignedFloat32(int index4, float value) {
        unsafe.putFloat(this.data, (long)index4 << 2, value);
    }

    @JTranscInline
    public final void setAlignedFloat64(int index8, double value) {
        unsafe.putDouble(this.data, (long)index8 << 3, value);
    }

    @JTranscInline
    public static void copy(FastMemory from, int fromOffset, byte[] to, int toOffset, int length) {
        for (int n = 0; n < length; ++n) {
            to[toOffset + n] = from.getInt8(fromOffset + n);
        }
    }
}

