/*
 * Decompiled with CFR 0.152.
 */
package com.jthinking.common.util.ip;

import com.jthinking.common.util.ip.IPInfoUtils;
import com.jthinking.common.util.ip.IPv4Info;
import com.jthinking.common.util.ip.IpUtils;
import com.jthinking.common.util.ip.ZipUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class IPv4InfoUtils {
    private static List<IPv4Info> ipv4InfoList;
    private static final IPv4Info UNKNOWN;
    private static final Map<String, String> COUNTRY_GEO;
    private static final Map<String, String> PROVINCE_GEO;
    private static final String provinces = "\u6cb3\u5317,\u5c71\u897f,\u8fbd\u5b81,\u5409\u6797,\u9ed1\u9f99,\u6c5f\u82cf,\u6d59\u6c5f,\u5b89\u5fbd,\u798f\u5efa,\u6c5f\u897f,\u5c71\u4e1c,\u6cb3\u5357,\u6e56\u5317,\u6e56\u5357,\u5e7f\u4e1c,\u6d77\u5357,\u56db\u5ddd,\u8d35\u5dde,\u4e91\u5357,\u9655\u897f,\u7518\u8083,\u9752\u6d77,\u53f0\u6e7e\u897f\u85cf,\u5e7f\u897f,\u5185\u8499,\u5b81\u590f,\u65b0\u7586,\u9999\u6e2f,\u6fb3\u95e8\u5317\u4eac,\u4e0a\u6d77,\u5929\u6d25,\u91cd\u5e86,\u4e2d\u56fd";

    public static synchronized void init() {
        String ipv4InfoName;
        File zipFile;
        if (ipv4InfoList != null && !ipv4InfoList.isEmpty()) {
            return;
        }
        String zipName = "ip.zip";
        String userDir = System.getProperty("user.dir");
        File tmp = new File(userDir + "/tmp");
        if (!tmp.exists()) {
            tmp.mkdir();
        }
        if ((zipFile = new File(tmp.getAbsolutePath() + "/" + zipName)).exists()) {
            zipFile.delete();
        }
        zipFile.setWritable(true);
        zipFile.setReadable(true);
        URL resource = IPv4InfoUtils.class.getClassLoader().getResource(zipName);
        if (resource == null) {
            throw new RuntimeException(zipName + " zip file not found");
        }
        try (InputStream in = resource.openStream();
             FileOutputStream out = new FileOutputStream(zipFile);){
            int len;
            byte[] temp = new byte[1024];
            while ((len = in.read(temp, 0, temp.length)) != -1) {
                out.write(temp, 0, len);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            ipv4InfoName = ZipUtils.unZipReturnDir(zipFile, tmp.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File ipv4InfoFile = new File(tmp.getAbsolutePath() + "/" + ipv4InfoName);
        try {
            FileInputStream inputStream = new FileInputStream(ipv4InfoFile);
            ipv4InfoList = IPv4InfoUtils.importTxt(inputStream);
            if (ipv4InfoList == null) {
                ipv4InfoList = Collections.emptyList();
            }
            ipv4InfoList.sort(Comparator.comparing(IPv4Info::getStartLong));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        ipv4InfoFile.deleteOnExit();
        zipFile.deleteOnExit();
    }

    public static IPv4Info getIPv4Info(String ip) {
        int index;
        if (ip == null) {
            return UNKNOWN;
        }
        if (ip.contains(":") || !IpUtils.isIp(ip)) {
            return UNKNOWN;
        }
        if (ipv4InfoList == null) {
            IPv4InfoUtils.init();
        }
        if ((index = Collections.binarySearch(ipv4InfoList, new IPv4Info(IpUtils.ip2long(ip), IpUtils.ip2long(ip)))) < 0 || index >= ipv4InfoList.size()) {
            return UNKNOWN;
        }
        return ipv4InfoList.get(index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<IPv4Info> importTxt(InputStream file) {
        ArrayList<IPv4Info> ipv4InfoList = new ArrayList<IPv4Info>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file, "GB18030"));){
            String line;
            while ((line = reader.readLine()) != null) {
                IPv4Info IPv4Info2 = IPv4InfoUtils.convertToIPv4Info(line);
                if (IPv4Info2 == null) continue;
                ipv4InfoList.add(IPv4Info2);
            }
            ArrayList<IPv4Info> arrayList = ipv4InfoList;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IPv4Info convertToIPv4Info(String row) {
        String g;
        String address;
        String province;
        boolean overseas;
        String country;
        if (row.trim().equals("")) {
            return null;
        }
        String[] split = row.split("\\s+", 4);
        if (split.length != 4) {
            return null;
        }
        String startIp = split[0].trim();
        if (!IpUtils.isIp(startIp)) {
            return null;
        }
        long startLong = IpUtils.ip2long(startIp);
        String endIp = split[1].trim();
        if (!IpUtils.isIp(endIp)) {
            return null;
        }
        long endLong = IpUtils.ip2long(endIp);
        String region = split[2].trim();
        String isp = split[3].replaceAll("CZ88\\.NET", "").trim();
        if (startIp.equals("255.255.255.0")) {
            region = "\u4fdd\u7559\u5730\u5740";
            isp = "\u4fdd\u7559\u5730\u5740";
        }
        String tmp = region.substring(0, 2);
        String geo = "0,0";
        if (provinces.contains(tmp)) {
            country = "\u4e2d\u56fd";
            overseas = false;
            province = IPv4InfoUtils.formatProvince(tmp);
            address = region;
            g = PROVINCE_GEO.get(province);
            if (g != null) {
                geo = g;
            }
        } else if (tmp.equals("\u5e7f\u5dde")) {
            country = "\u4e2d\u56fd";
            overseas = false;
            province = "\u5e7f\u4e1c";
            address = region;
            geo = PROVINCE_GEO.get("\u5e7f\u4e1c");
        } else if (tmp.equals("\u6210\u90fd")) {
            country = "\u4e2d\u56fd";
            overseas = false;
            province = "\u56db\u5ddd";
            address = region;
            geo = PROVINCE_GEO.get("\u56db\u5ddd");
        } else if (tmp.equals("\u6c88\u9633")) {
            country = "\u4e2d\u56fd";
            overseas = false;
            province = "\u8fbd\u5b81";
            address = region;
            geo = PROVINCE_GEO.get("\u8fbd\u5b81");
        } else if (region.contains("\u5927\u5b66") || region.contains("\u5b66\u9662") || region.contains("\u4e1c\u5317")) {
            country = "\u4e2d\u56fd";
            overseas = false;
            province = "";
            address = region;
            geo = PROVINCE_GEO.get("\u4e2d\u56fd");
        } else if (region.contains("\u5c40\u57df\u7f51") || isp.contains("\u5c40\u57df\u7f51")) {
            country = "\u5c40\u57df\u7f51";
            overseas = false;
            province = "";
            address = region;
        } else if (region.contains("\u4fdd\u7559\u5730\u5740") || isp.contains("\u4fdd\u7559\u5730\u5740")) {
            country = "\u4fdd\u7559\u5730\u5740";
            overseas = false;
            province = "";
            address = region;
        } else if (region.contains("\u672c\u673a\u5730\u5740") || isp.contains("\u672c\u673a\u5730\u5740")) {
            country = "\u672c\u673a\u5730\u5740";
            overseas = false;
            province = "";
            address = region;
        } else {
            country = region;
            overseas = true;
            province = "";
            address = region;
            g = COUNTRY_GEO.get(country);
            if (g != null) {
                geo = g;
            }
        }
        String[] latAndLng = geo.split(",");
        double lat = Double.parseDouble(latAndLng[0]);
        double lng = Double.parseDouble(latAndLng[1]);
        return new IPv4Info(startLong, endLong, country, province, address, isp, overseas, lat, lng);
    }

    private static String formatProvince(String originalData) {
        String result;
        switch (originalData) {
            case "\u5185\u8499": {
                result = "\u5185\u8499\u53e4";
                break;
            }
            case "\u9ed1\u9f99": {
                result = "\u9ed1\u9f99\u6c5f";
                break;
            }
            default: {
                result = originalData;
            }
        }
        return result;
    }

    static {
        UNKNOWN = new IPv4Info(0L, 0L, "\u672a\u77e5", "\u672a\u77e5", "\u672a\u77e5", "\u672a\u77e5", false, 0.0, 0.0);
        COUNTRY_GEO = IPInfoUtils.COUNTRY_GEO;
        PROVINCE_GEO = IPInfoUtils.PROVINCE_GEO;
    }
}

