/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.collect.MapMaker;
import com.jolbox.bonecp.IStatementCache;
import com.jolbox.bonecp.StatementHandle;
import com.jolbox.bonecp.Statistics;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementCache
implements IStatementCache {
    private static Logger logger = LoggerFactory.getLogger(StatementCache.class);
    private ConcurrentMap<String, StatementHandle> cache;
    private int cacheSize;
    private final boolean maintainStats;
    private final Statistics statistics;

    public StatementCache(int size, boolean maintainStats, Statistics statistics) {
        this.maintainStats = maintainStats;
        this.statistics = statistics;
        this.cache = new MapMaker().concurrencyLevel(32).makeMap();
        this.cacheSize = size;
    }

    @Override
    public String calculateCacheKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        StringBuilder tmp = this.calculateCacheKeyInternal(sql, resultSetType, resultSetConcurrency);
        tmp.append(", H:");
        tmp.append(resultSetHoldability);
        return tmp.toString();
    }

    @Override
    public String calculateCacheKey(String sql, int resultSetType, int resultSetConcurrency) {
        StringBuilder tmp = this.calculateCacheKeyInternal(sql, resultSetType, resultSetConcurrency);
        return tmp.toString();
    }

    private StringBuilder calculateCacheKeyInternal(String sql, int resultSetType, int resultSetConcurrency) {
        StringBuilder tmp = new StringBuilder(sql.length() + 20);
        tmp.append(sql);
        tmp.append(", T");
        tmp.append(resultSetType);
        tmp.append(", C");
        tmp.append(resultSetConcurrency);
        return tmp;
    }

    @Override
    public String calculateCacheKey(String sql, int autoGeneratedKeys) {
        StringBuilder tmp = new StringBuilder(sql.length() + 4);
        tmp.append(sql);
        tmp.append(autoGeneratedKeys);
        return tmp.toString();
    }

    @Override
    public String calculateCacheKey(String sql, int[] columnIndexes) {
        StringBuilder tmp = new StringBuilder(sql.length() + 4);
        tmp.append(sql);
        for (int i = 0; i < columnIndexes.length; ++i) {
            tmp.append(columnIndexes[i]);
            tmp.append("CI,");
        }
        return tmp.toString();
    }

    @Override
    public String calculateCacheKey(String sql, String[] columnNames) {
        StringBuilder tmp = new StringBuilder(sql.length() + 4);
        tmp.append(sql);
        for (int i = 0; i < columnNames.length; ++i) {
            tmp.append(columnNames[i]);
            tmp.append("CN,");
        }
        return tmp.toString();
    }

    @Override
    public StatementHandle get(String key) {
        StatementHandle statement = (StatementHandle)this.cache.get(key);
        if (statement != null && !statement.logicallyClosed.compareAndSet(true, false)) {
            statement = null;
        }
        if (this.maintainStats) {
            if (statement != null) {
                this.statistics.incrementCacheHits();
            } else {
                this.statistics.incrementCacheMiss();
            }
        }
        return statement;
    }

    @Override
    public StatementHandle get(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return this.get(this.calculateCacheKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public StatementHandle get(String sql, int resultSetType, int resultSetConcurrency) {
        return this.get(this.calculateCacheKey(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public StatementHandle get(String sql, int autoGeneratedKeys) {
        return this.get(this.calculateCacheKey(sql, autoGeneratedKeys));
    }

    @Override
    public StatementHandle get(String sql, int[] columnIndexes) {
        return this.get(this.calculateCacheKey(sql, columnIndexes));
    }

    @Override
    public StatementHandle get(String sql, String[] columnNames) {
        return this.get(this.calculateCacheKey(sql, columnNames));
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        for (StatementHandle statement : this.cache.values()) {
            try {
                statement.internalClose();
            }
            catch (SQLException sQLException) {}
        }
        this.cache.clear();
    }

    @Override
    public void checkForProperClosure() {
        for (StatementHandle statement : this.cache.values()) {
            if (statement.isClosed()) continue;
            logger.error("Statement not closed properly in application\n\n" + statement.getOpenStackTrace());
        }
    }

    @Override
    public void putIfAbsent(String key, StatementHandle handle) {
        if (this.cache.size() <= this.cacheSize && key != null && this.cache.putIfAbsent(key, handle) == null) {
            handle.inCache = true;
            if (this.maintainStats) {
                this.statistics.incrementStatementsCached();
            }
        }
    }
}

