/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.StatisticsMBean;
import java.util.concurrent.atomic.AtomicLong;

public class Statistics
implements StatisticsMBean {
    private final AtomicLong cacheHits = new AtomicLong(0L);
    private final AtomicLong cacheMiss = new AtomicLong(0L);
    private final AtomicLong statementsCached = new AtomicLong(0L);
    private final AtomicLong connectionsRequested = new AtomicLong(0L);
    private final AtomicLong cumulativeConnectionWaitTime = new AtomicLong(0L);
    private final AtomicLong cumulativeStatementExecuteTime = new AtomicLong(0L);
    private final AtomicLong cumulativeStatementPrepareTime = new AtomicLong(0L);
    private final AtomicLong statementsExecuted = new AtomicLong(0L);
    private final AtomicLong statementsPrepared = new AtomicLong(0L);
    private BoneCP pool;

    public Statistics(BoneCP pool) {
        this.pool = pool;
    }

    @Override
    public void resetStats() {
        this.cacheHits.set(0L);
        this.cacheMiss.set(0L);
        this.statementsCached.set(0L);
        this.connectionsRequested.set(0L);
        this.cumulativeConnectionWaitTime.set(0L);
        this.cumulativeStatementExecuteTime.set(0L);
        this.cumulativeStatementPrepareTime.set(0L);
        this.statementsExecuted.set(0L);
        this.statementsPrepared.set(0L);
    }

    @Override
    public double getConnectionWaitTimeAvg() {
        return this.connectionsRequested.get() == 0L ? 0.0 : (double)this.cumulativeConnectionWaitTime.get() / (1.0 * (double)this.connectionsRequested.get()) / 1000000.0;
    }

    @Override
    public double getStatementExecuteTimeAvg() {
        return this.statementsExecuted.get() == 0L ? 0.0 : (double)this.cumulativeStatementExecuteTime.get() / (1.0 * (double)this.statementsExecuted.get()) / 1000000.0;
    }

    @Override
    public double getStatementPrepareTimeAvg() {
        return this.cumulativeStatementPrepareTime.get() == 0L ? 0.0 : (double)this.cumulativeStatementPrepareTime.get() / (1.0 * (double)this.statementsPrepared.get()) / 1000000.0;
    }

    @Override
    public int getTotalLeased() {
        return this.pool.getTotalLeased();
    }

    @Override
    public int getTotalFree() {
        return this.pool.getTotalFree();
    }

    @Override
    public int getTotalCreatedConnections() {
        return this.pool.getTotalCreatedConnections();
    }

    @Override
    public long getCacheHits() {
        return this.cacheHits.get();
    }

    @Override
    public long getCacheMiss() {
        return this.cacheMiss.get();
    }

    @Override
    public long getStatementsCached() {
        return this.statementsCached.get();
    }

    @Override
    public long getConnectionsRequested() {
        return this.connectionsRequested.get();
    }

    @Override
    public long getCumulativeConnectionWaitTime() {
        return this.cumulativeConnectionWaitTime.get() / 1000000L;
    }

    protected void addCumulativeConnectionWaitTime(long increment) {
        this.cumulativeConnectionWaitTime.addAndGet(increment);
    }

    protected void incrementStatementsExecuted() {
        this.statementsExecuted.incrementAndGet();
    }

    protected void incrementStatementsPrepared() {
        this.statementsPrepared.incrementAndGet();
    }

    protected void incrementStatementsCached() {
        this.statementsCached.incrementAndGet();
    }

    protected void incrementCacheMiss() {
        this.cacheMiss.incrementAndGet();
    }

    protected void incrementCacheHits() {
        this.cacheHits.incrementAndGet();
    }

    protected void incrementConnectionsRequested() {
        this.connectionsRequested.incrementAndGet();
    }

    @Override
    public double getCacheHitRatio() {
        return this.cacheHits.get() + this.cacheMiss.get() == 0L ? 0.0 : (double)this.cacheHits.get() / (1.0 * (double)this.cacheHits.get() + (double)this.cacheMiss.get());
    }

    @Override
    public long getStatementsExecuted() {
        return this.statementsExecuted.get();
    }

    @Override
    public long getCumulativeStatementExecutionTime() {
        return this.cumulativeStatementExecuteTime.get() / 1000000L;
    }

    protected void addStatementExecuteTime(long time) {
        this.cumulativeStatementExecuteTime.addAndGet(time);
    }

    protected void addStatementPrepareTime(long time) {
        this.cumulativeStatementPrepareTime.addAndGet(time);
    }

    @Override
    public long getCumulativeStatementPrepareTime() {
        return this.cumulativeStatementPrepareTime.get() / 1000000L;
    }

    @Override
    public long getStatementsPrepared() {
        return this.statementsPrepared.get();
    }
}

