/*
 * Decompiled with CFR 0.152.
 */
package com.joanzapata.pdfview;

class SpiralLoopManager {
    private SpiralLoopListener listener;

    public SpiralLoopManager(SpiralLoopListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("SpiralLoopListener must not be null");
        }
        this.listener = listener;
    }

    public void startLoop(int nbRows, int nbCols, int startRow, int startCol) {
        int totalNbCells = nbCols * nbRows;
        int nbMarkedCells = 0;
        int row = startRow;
        int col = startCol;
        int progress = 1;
        int variation = 1;
        this.listener.onLoop(row, col);
        ++nbMarkedCells;
        while (nbMarkedCells < totalNbCells) {
            boolean canContinue;
            int i;
            for (i = 0; i < progress; ++i) {
                if (!this.isValidCell(row += variation, col, nbRows, nbCols)) continue;
                ++nbMarkedCells;
                canContinue = this.listener.onLoop(row, col);
                if (canContinue) continue;
                return;
            }
            for (i = 0; i < progress; ++i) {
                if (!this.isValidCell(row, col += variation, nbRows, nbCols)) continue;
                ++nbMarkedCells;
                canContinue = this.listener.onLoop(row, col);
                if (canContinue) continue;
                return;
            }
            ++progress;
            variation *= -1;
        }
    }

    private boolean isValidCell(int row, int col, int nbRows, int nbCols) {
        return row >= 0 && row < nbRows && col >= 0 && col < nbCols;
    }

    public static interface SpiralLoopListener {
        public boolean onLoop(int var1, int var2);
    }
}

