package com.jimi.jmmonitorview;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class JMGLSurfaceViewRenderer implements GLSurfaceView.Renderer {
    private Context context;
    private int mViewWidth;
    private int mViewHeight;
    private int mFrameWidth;
    private int mFrameHeight;
    private byte[] mDataY = null;
    private byte[] mDataU = null;
    private byte[] mDataV = null;

    public JMGLSurfaceViewRenderer(Context context) {
        this.context = context;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mViewWidth = width;
        this.mViewHeight = height;
        initGL();
    }

    public void onDrawFrame(GL10 gl) {
        if (this.mDataY != null && this.mDataU != null && this.mDataV != null) {
            JMMonitorViewJni.LoadYUVData(mFrameWidth, mFrameHeight, mDataY, mDataU, mDataV);
            JMMonitorViewJni.Render(mViewWidth, mViewHeight);
        }
    }

    public void initGL() {
        JMMonitorViewJni.Init();
    }

    public void releaseGL() {
        JMMonitorViewJni.Release();
    }

    public void displayYUVData(int w, int h, byte[] y, byte[] u, byte[] v) {
        this.mFrameWidth = w;
        this.mFrameHeight = h;

        if (y.length > 0 && u.length > 0 && v.length > 0) {
            mDataY = y;
            mDataU = u;
            mDataV = v;
        }
    }

    public Bitmap snapshot() {
        synchronized (this) {
            int width = mFrameWidth;
            int height = mFrameHeight;

            if (width > 0 && height > 0 && this.mDataY != null && this.mDataU != null && this.mDataV != null) {
                byte[] dataY = mDataY; //new byte[this.mDataY.length];
                byte[] dataU = mDataU; //new byte[this.mDataU.length];
                byte[] dataV = mDataV; //new byte[this.mDataV.length];
//            System.arraycopy(mDataY, 0, dataY, 0, dataY.length);
//            System.arraycopy(mDataU, 0, dataU, 0, dataU.length);
//            System.arraycopy(mDataV, 0, dataV, 0, dataV.length);

                int frameSize = width * height;
                int[] rgba = new int[frameSize];
                for (int i = 0; i < height; i++) {
                    for (int j = 0; j < width; j++) {
                        int y = (0xff & ((int) dataY[i * width + j]));
                        int u = (0xff & ((int) dataU[(i / 2) * (width / 2) + (j / 2)]));
                        int v = (0xff & ((int) dataV[(i / 2) * (width / 2) + (j / 2)]));
                        y = y < 16 ? 16 : y;
                        int r = (int) (y + 1.732446 * (u - 128));
                        int g = (int) (y - 0.698001 * (u - 128) - 0.703125 * (v - 128));
                        int b = (int) (y + 1.370705 * (v - 128));
                        r = r < 0 ? 0 : (r > 255 ? 255 : r);
                        g = g < 0 ? 0 : (g > 255 ? 255 : g);
                        b = b < 0 ? 0 : (b > 255 ? 255 : b);
                        rgba[i * width + j] = 0xff000000 + (b << 16) + (g << 8) + r;
                    }
                }
                Bitmap bmp = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                bmp.setPixels(rgba, 0, width, 0, 0, width, height);
                return bmp;
            }
        }

        return null;
    }

}
