/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jmmonitorview;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import com.jimi.jmmonitorview.JMMonitorViewJni;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class JMGLSurfaceViewRenderer
implements GLSurfaceView.Renderer {
    private Context context;
    private int mViewWidth;
    private int mViewHeight;
    private int mFrameWidth;
    private int mFrameHeight;
    private byte[] mDataY = null;
    private byte[] mDataU = null;
    private byte[] mDataV = null;

    public JMGLSurfaceViewRenderer(Context context) {
        this.context = context;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mViewWidth = width;
        this.mViewHeight = height;
        this.initGL();
    }

    public void onDrawFrame(GL10 gl) {
        if (this.mDataY != null && this.mDataU != null && this.mDataV != null) {
            JMMonitorViewJni.LoadYUVData(this.mFrameWidth, this.mFrameHeight, this.mDataY, this.mDataU, this.mDataV);
            JMMonitorViewJni.Render(this.mViewWidth, this.mViewHeight);
        }
    }

    public void initGL() {
        JMMonitorViewJni.Init();
    }

    public void releaseGL() {
        JMMonitorViewJni.Release();
    }

    public void displayYUVData(int w, int h, byte[] y, byte[] u, byte[] v) {
        this.mFrameWidth = w;
        this.mFrameHeight = h;
        if (y.length > 0 && u.length > 0 && v.length > 0) {
            this.mDataY = y;
            this.mDataU = u;
            this.mDataV = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap snapshot() {
        JMGLSurfaceViewRenderer jMGLSurfaceViewRenderer = this;
        synchronized (jMGLSurfaceViewRenderer) {
            int width = this.mFrameWidth;
            int height = this.mFrameHeight;
            if (width > 0 && height > 0 && this.mDataY != null && this.mDataU != null && this.mDataV != null) {
                byte[] dataY = this.mDataY;
                byte[] dataU = this.mDataU;
                byte[] dataV = this.mDataV;
                int frameSize = width * height;
                int[] rgba = new int[frameSize];
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        int y = 0xFF & dataY[i * width + j];
                        int u = 0xFF & dataU[i / 2 * (width / 2) + j / 2];
                        int v = 0xFF & dataV[i / 2 * (width / 2) + j / 2];
                        y = y < 16 ? 16 : y;
                        int r = (int)((double)y + 1.732446 * (double)(u - 128));
                        int g = (int)((double)y - 0.698001 * (double)(u - 128) - 0.703125 * (double)(v - 128));
                        int b = (int)((double)y + 1.370705 * (double)(v - 128));
                        int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                        int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                        b = b < 0 ? 0 : (b > 255 ? 255 : b);
                        rgba[i * width + j] = -16777216 + (b << 16) + (g << 8) + r;
                    }
                }
                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.setPixels(rgba, 0, width, 0, 0, width, height);
                return bmp;
            }
        }
        return null;
    }
}

