/*
 * Decompiled with CFR 0.152.
 */
package com.jimi.jmlog;

import android.util.Log;
import com.jimi.jmlog.JMLogConfig;
import org.apache.log4j.Logger;

public class JMLog {
    private static Logger mLogger = null;
    public static JMLogConfig config = new JMLogConfig();

    private static JMLogConfig getConfig() {
        if (config == null) {
            config = new JMLogConfig();
        }
        return config;
    }

    private static Logger getLoger(String tag) {
        if (mLogger == null) {
            JMLog.getConfig().configure();
            mLogger = Logger.getLogger((String)tag);
            mLogger.addAppender(JMLog.getConfig().appender());
        }
        if (mLogger != null && !tag.equals(mLogger.getName())) {
            mLogger = Logger.getLogger((String)tag);
        }
        return mLogger;
    }

    public static void v(String tag, String msg) {
        if (JMLog.getConfig().isDebug && msg != null) {
            if (JMLog.getConfig().isSave) {
                JMLog.getLoger(tag).debug((Object)msg);
            } else {
                Log.v((String)tag, (String)msg);
            }
        }
    }

    public static void d(String tag, String msg) {
        if (JMLog.getConfig().isDebug && msg != null) {
            if (JMLog.getConfig().isSave) {
                JMLog.getLoger(tag).debug((Object)msg);
            } else {
                Log.d((String)tag, (String)msg);
            }
        }
    }

    public static void i(String tag, String msg) {
        if (JMLog.getConfig().isDebug && msg != null) {
            if (JMLog.getConfig().isSave) {
                JMLog.getLoger(tag).info((Object)msg);
            } else {
                Log.i((String)tag, (String)msg);
            }
        }
    }

    public static void w(String tag, String msg) {
        if (JMLog.getConfig().isDebug && msg != null) {
            if (JMLog.getConfig().isSave) {
                JMLog.getLoger(tag).warn((Object)msg);
            } else {
                Log.w((String)tag, (String)msg);
            }
        }
    }

    public static void e(String tag, String msg) {
        if (JMLog.getConfig().isDebug && msg != null) {
            if (JMLog.getConfig().isSave) {
                JMLog.getLoger(tag).error((Object)msg);
            } else {
                Log.e((String)tag, (String)msg);
            }
        }
    }

    public static void log(int prio, String msg) {
        if (prio == 2) {
            JMLog.v(msg);
        } else if (prio == 3) {
            JMLog.d(msg);
        } else if (prio == 4) {
            JMLog.i(msg);
        } else if (prio == 5) {
            JMLog.w(msg);
        } else if (prio == 6) {
            JMLog.e(msg);
        } else {
            JMLog.d(msg);
        }
    }

    public static void v(String msg) {
        JMLog.v(JMLog.getConfig().getTAG(), msg);
    }

    public static void d(String msg) {
        JMLog.d(JMLog.getConfig().getTAG(), msg);
    }

    public static void i(String msg) {
        JMLog.i(JMLog.getConfig().getTAG(), msg);
    }

    public static void w(String msg) {
        JMLog.w(JMLog.getConfig().getTAG(), msg);
    }

    public static void e(String msg) {
        JMLog.e(JMLog.getConfig().getTAG(), msg);
    }

    public static void log(String msg) {
        JMLog.e(JMLog.getConfig().getTAG(), msg);
    }

    public static void printBytes(String logHint, byte[] buffer) {
        String finalString = logHint;
        for (int i = 0; i < buffer.length; ++i) {
            String hex = Integer.toHexString(buffer[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            finalString = finalString == null ? hex : finalString + " " + hex;
        }
        JMLog.d(finalString);
    }
}

