package com.jimi.jmlog;

import android.util.Log;
import org.apache.log4j.Logger;

public class JMLog {
    private static Logger mLogger = null;
    public static JMLogConfig config = new JMLogConfig();

    public JMLog() {

    }

    private static JMLogConfig getConfig() {
        if (config == null) {
            config = new JMLogConfig();
        }

        return config;
    }

    private static Logger getLoger(String tag) {
        if (mLogger == null) {
            getConfig().configure();
            mLogger = Logger.getLogger(tag);
            mLogger.addAppender(getConfig().appender());
        }

        if (mLogger != null && !tag.equals(mLogger.getName())) {
            mLogger = Logger.getLogger(tag);
        }
        return mLogger;
    }

    public static void v(String tag, String msg) {
        if (getConfig().isDebug && msg != null) {
            if (getConfig().isSave) {
                getLoger(tag).debug(msg);
            } else {
                Log.v(tag, msg);

            }
        }
    }

    public static void d(String tag, String msg) {
        if (getConfig().isDebug && msg != null) {
            if (getConfig().isSave) {
                getLoger(tag).debug(msg);
            } else {
                Log.d(tag, msg);
            }
        }
    }

    public static void i(String tag, String msg) {
        if (getConfig().isDebug && msg != null) {
            if (getConfig().isSave) {
                getLoger(tag).info(msg);
            } else {
                Log.i(tag, msg);
            }
        }
    }

    public static void w(String tag, String msg) {
        if (getConfig().isDebug && msg != null) {
            if (getConfig().isSave) {
                getLoger(tag).warn(msg);
            } else {
                Log.w(tag, msg);
            }
        }
    }

    public static void e(String tag, String msg) {
        if (getConfig().isDebug && msg != null) {
            if (getConfig().isSave) {
                getLoger(tag).error(msg);
            } else {
                Log.e(tag, msg);
            }
        }
    }

    public static void log(int prio, String msg) {
        if (prio == 2) {  //ANDROID_LOG_VERBOSE
            v(msg);
        } else if (prio == 3) {
            d(msg);
        } else if (prio == 4) {
            i(msg);
        } else if (prio == 5) {
            w(msg);
        } else if (prio == 6) {
            e(msg);
        } else {
            d(msg);
        }
    }

    public static void v(String msg) {
        v(getConfig().getTAG(), msg);
    }
    public static void d(String msg) {
        d(getConfig().getTAG(), msg);
    }
    public static void i(String msg) {
        i(getConfig().getTAG(), msg);
    }
    public static void w(String msg) {
        w(getConfig().getTAG(), msg);
    }
    public static void e(String msg) {
        e(getConfig().getTAG(), msg);
    }
    public static void log(String msg) {
        JMLog.e(getConfig().getTAG(), msg);
    }

    public static void printBytes(String logHint, byte[] buffer) {
        String finalString = logHint;
        for (int i = 0; i < buffer.length; i++) {
            String hex = Integer.toHexString(buffer[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }

            if (finalString == null) {
                finalString = hex;
            } else {
                finalString += (" " + hex);
            }
        }
        JMLog.d(finalString);
    }
}
