/*
 * Decompiled with CFR 0.152.
 */
package net.grandcentrix.tray.provider;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import net.grandcentrix.tray.core.TrayStorage;
import net.grandcentrix.tray.provider.TrayContract;

class TrayUri {
    private final Uri mContentUri;
    private final Uri mContentUriInternal;
    private Context mContext;

    public TrayUri(@NonNull Context context) {
        this.mContext = context;
        this.mContentUri = TrayContract.generateContentUri(context);
        this.mContentUriInternal = TrayContract.generateInternalContentUri(context);
    }

    public Builder builder() {
        return new Builder(this.mContext);
    }

    public Uri get() {
        return this.mContentUri;
    }

    public Uri getInternal() {
        return this.mContentUriInternal;
    }

    public final class Builder {
        private boolean mInternal;
        private String mKey;
        private String mModule;
        private TrayStorage.Type mType = TrayStorage.Type.UNDEFINED;

        public Builder(Context context) {
            TrayUri.this.mContext = context.getApplicationContext();
        }

        public Uri build() {
            Uri uri = this.mInternal ? TrayUri.this.mContentUriInternal : TrayUri.this.mContentUri;
            Uri.Builder builder = uri.buildUpon();
            if (this.mModule != null) {
                builder.appendPath(this.mModule);
            }
            if (this.mKey != null) {
                builder.appendPath(this.mKey);
            }
            if (this.mType != TrayStorage.Type.UNDEFINED) {
                builder.appendQueryParameter("backup", TrayStorage.Type.USER.equals((Object)this.mType) ? "true" : "false");
            }
            return builder.build();
        }

        public Builder setInternal(boolean internal) {
            this.mInternal = internal;
            return this;
        }

        public Builder setKey(String key) {
            this.mKey = key;
            return this;
        }

        public Builder setModule(String module) {
            this.mModule = module;
            return this;
        }

        public Builder setType(TrayStorage.Type type) {
            this.mType = type;
            return this;
        }
    }
}

