/*
 * Decompiled with CFR 0.152.
 */
package net.grandcentrix.tray.provider;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.grandcentrix.tray.core.AbstractTrayPreference;
import net.grandcentrix.tray.core.TrayException;
import net.grandcentrix.tray.core.TrayItem;
import net.grandcentrix.tray.provider.SqliteHelper;
import net.grandcentrix.tray.provider.TrayUri;

public class TrayProviderHelper {
    private final Context mContext;
    private final TrayUri mTrayUri;

    public TrayProviderHelper(@NonNull Context context) {
        this.mContext = context;
        this.mTrayUri = new TrayUri(context);
    }

    public boolean clear() {
        try {
            this.mContext.getContentResolver().delete(this.mTrayUri.get(), null, null);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean clearBut(AbstractTrayPreference ... modules) {
        String selection = null;
        String[] selectionArgs = new String[]{};
        for (AbstractTrayPreference module : modules) {
            if (module == null) continue;
            String moduleName = module.getName();
            selection = SqliteHelper.extendSelection(selection, "MODULE != ?");
            selectionArgs = SqliteHelper.extendSelectionArgs(selectionArgs, new String[]{moduleName});
        }
        try {
            this.mContext.getContentResolver().delete(this.mTrayUri.get(), selection, selectionArgs);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @NonNull
    public List<TrayItem> getAll() {
        return this.queryProviderSafe(this.mTrayUri.get());
    }

    public boolean persist(@NonNull String module, @NonNull String key, @NonNull String value) {
        return this.persist(module, key, null, value);
    }

    public boolean persist(@NonNull String module, @NonNull String key, @Nullable String previousKey, @Nullable String value) {
        Uri uri = this.mTrayUri.builder().setModule(module).setKey(key).build();
        return this.persist(uri, value, previousKey);
    }

    public boolean persist(@NonNull Uri uri, @Nullable String value) {
        return this.persist(uri, value, null);
    }

    public boolean persist(@NonNull Uri uri, @Nullable String value, @Nullable String previousKey) {
        ContentValues values = new ContentValues();
        values.put("VALUE", value);
        values.put("MIGRATED_KEY", previousKey);
        try {
            return this.mContext.getContentResolver().insert(uri, values) != null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @NonNull
    public List<TrayItem> queryProvider(@NonNull Uri uri) throws TrayException {
        Cursor cursor;
        try {
            cursor = this.mContext.getContentResolver().query(uri, null, null, null, null);
        }
        catch (Throwable e) {
            throw new TrayException("Hard error accessing the ContentProvider", e);
        }
        if (cursor == null) {
            throw new TrayException("could not access stored data with uri " + uri);
        }
        ArrayList<TrayItem> list = new ArrayList<TrayItem>();
        boolean hasItem = cursor.moveToFirst();
        while (hasItem) {
            TrayItem trayItem = TrayProviderHelper.cursorToTrayItem(cursor);
            list.add(trayItem);
            hasItem = cursor.moveToNext();
        }
        cursor.close();
        return list;
    }

    @NonNull
    public List<TrayItem> queryProviderSafe(@NonNull Uri uri) {
        try {
            return this.queryProvider(uri);
        }
        catch (TrayException e) {
            return new ArrayList<TrayItem>();
        }
    }

    public boolean remove(Uri uri) {
        try {
            this.mContext.getContentResolver().delete(uri, null, null);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public int removeAndCount(Uri uri) {
        try {
            return this.mContext.getContentResolver().delete(uri, null, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean wipe() {
        if (!this.clear()) {
            return false;
        }
        try {
            return this.mContext.getContentResolver().delete(this.mTrayUri.getInternal(), null, null) > 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @NonNull
    static TrayItem cursorToTrayItem(Cursor cursor) {
        String module = cursor.getString(cursor.getColumnIndexOrThrow("MODULE"));
        String key = cursor.getString(cursor.getColumnIndexOrThrow("KEY"));
        String migratedKey = cursor.getString(cursor.getColumnIndexOrThrow("MIGRATED_KEY"));
        String value = cursor.getString(cursor.getColumnIndexOrThrow("VALUE"));
        Date created = new Date(cursor.getLong(cursor.getColumnIndexOrThrow("CREATED")));
        Date updated = new Date(cursor.getLong(cursor.getColumnIndexOrThrow("UPDATED")));
        return new TrayItem(module, key, migratedKey, value, created, updated);
    }
}

