/*
 * Decompiled with CFR 0.152.
 */
package net.grandcentrix.tray.provider;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import net.grandcentrix.tray.core.TrayLog;

@VisibleForTesting
public class TrayDBHelper
extends SQLiteOpenHelper {
    public static final String TABLE_NAME = "TrayPreferences";
    public static final String INTERNAL_TABLE_NAME = "TrayInternal";
    public static final String DATABASE_NAME = "tray.db";
    public static final String DATABASE_NAME_NO_BACKUP = "tray_backup_excluded.db";
    public static final String KEY = "KEY";
    public static final String VALUE = "VALUE";
    public static final String MODULE = "MODULE";
    public static final String CREATED = "CREATED";
    public static final String UPDATED = "UPDATED";
    public static final String MIGRATED_KEY = "MIGRATED_KEY";
    public static final String V1_PREFERENCES_CREATE = "CREATE TABLE TrayPreferences ( _id INTEGER PRIMARY KEY, KEY TEXT NOT NULL, VALUE TEXT, MODULE TEXT, CREATED INT DEFAULT 0, UPDATED INT DEFAULT 0, UNIQUE (MODULE, KEY));";
    public static final String V2_ALTER_PREFERENCES_TABLE = "ALTER TABLE TrayPreferences ADD COLUMN MIGRATED_KEY TEXT";
    public static final String V2_CREATE_INTERNAL_TRAY_TABLE = "CREATE TABLE TrayInternal ( _id INTEGER PRIMARY KEY, KEY TEXT NOT NULL, VALUE TEXT, MODULE TEXT, CREATED INT DEFAULT 0, UPDATED INT DEFAULT 0, MIGRATED_KEY TEXT, UNIQUE (MODULE, KEY));";
    static final int DATABASE_VERSION = 2;
    private final int mCreateVersion;
    private final boolean mWithBackup;

    TrayDBHelper(Context context, String databaseName, boolean withBackup, int databaseVersion) {
        super(context, databaseName, null, databaseVersion);
        this.mWithBackup = withBackup;
        this.mCreateVersion = databaseVersion;
    }

    public TrayDBHelper(Context context) {
        this(context, true);
    }

    public TrayDBHelper(Context context, boolean withBackup) {
        super(context, withBackup ? DATABASE_NAME : DATABASE_NAME_NO_BACKUP, null, 2);
        this.mWithBackup = withBackup;
        this.mCreateVersion = 2;
    }

    public void onCreate(SQLiteDatabase db) {
        TrayLog.v(this.logTag() + "onCreate with version " + this.mCreateVersion);
        this.createV1(db);
        TrayLog.v(this.logTag() + "created database version 1");
        if (this.mCreateVersion > 1) {
            this.onUpgrade(db, 1, this.mCreateVersion);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        TrayLog.v(this.logTag() + "upgrading Database from version " + oldVersion + " to version " + newVersion);
        if (newVersion > 2) {
            throw new IllegalStateException("onUpgrade doesn't support the upgrade to version " + newVersion);
        }
        switch (oldVersion) {
            case 1: {
                this.upgradeToV2(db);
                TrayLog.v(this.logTag() + "upgraded Database to version 2");
                break;
            }
            default: {
                throw new IllegalArgumentException("onUpgrade() with oldVersion <= 0 is useless");
            }
        }
    }

    private void createV1(SQLiteDatabase db) {
        db.execSQL(V1_PREFERENCES_CREATE);
    }

    @NonNull
    private String logTag() {
        return "tray internal db (" + (this.mWithBackup ? "backup" : "no backup") + "): ";
    }

    private void upgradeToV2(SQLiteDatabase db) {
        db.execSQL(V2_ALTER_PREFERENCES_TABLE);
        db.execSQL(V2_CREATE_INTERNAL_TRAY_TABLE);
    }
}

