/*
 * Decompiled with CFR 0.152.
 */
package net.grandcentrix.tray.provider;

import android.content.Context;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Process;
import android.provider.BaseColumns;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import java.util.List;
import net.grandcentrix.tray.R;
import net.grandcentrix.tray.core.TrayLog;
import net.grandcentrix.tray.core.TrayRuntimeException;
import net.grandcentrix.tray.provider.TrayContentProvider;

class TrayContract {
    @VisibleForTesting
    static String sAuthority;

    TrayContract() {
    }

    @NonNull
    public static Uri generateContentUri(@NonNull Context context) {
        return TrayContract.generateContentUri(context, "preferences");
    }

    @NonNull
    static Uri generateInternalContentUri(@NonNull Context context) {
        return TrayContract.generateContentUri(context, "internal_preferences");
    }

    private static void checkOldWayToSetAuthority(@NonNull Context context) {
        if (!"legacyTrayAuthority".equals(context.getString(R.string.tray__authority))) {
            Log.e((String)"Tray", (String)"Deprecated way of defining the Tray authority detected\n#########################################\n#########################################\n#########################################\nDon't set the authority with `tray__authority` in your build.gradle.\nTo change the default authority override it inside the AndroidManifest\nSee https://github.com/grandcentrix/tray/wiki/Custom-Authority for instructions\n#########################################\n#########################################\n#########################################\n");
        }
    }

    @NonNull
    private static Uri generateContentUri(@NonNull Context context, String basepath) {
        String authority = TrayContract.getAuthority(context);
        Uri authorityUri = Uri.parse((String)("content://" + authority));
        Uri contentUri = Uri.withAppendedPath((Uri)authorityUri, (String)basepath);
        return contentUri;
    }

    @NonNull
    private static synchronized String getAuthority(@NonNull Context context) {
        if (sAuthority != null) {
            return sAuthority;
        }
        TrayContract.checkOldWayToSetAuthority(context);
        List providers = context.getPackageManager().queryContentProviders(context.getPackageName(), Process.myUid(), 0);
        if (providers != null) {
            for (ProviderInfo provider : providers) {
                if (!provider.name.equals(TrayContentProvider.class.getName())) continue;
                sAuthority = provider.authority;
                TrayLog.v("found authority: " + sAuthority);
                return sAuthority;
            }
        }
        throw new TrayRuntimeException("Internal tray error. Could not find the provider authority. Please fill an issue at https://github.com/grandcentrix/tray/issues");
    }

    public static interface InternalPreferences
    extends Preferences {
        public static final String BASE_PATH = "internal_preferences";
    }

    public static interface Preferences {
        public static final String BASE_PATH = "preferences";

        public static interface Columns
        extends BaseColumns {
            public static final String ID = "_id";
            public static final String KEY = "KEY";
            public static final String VALUE = "VALUE";
            public static final String MODULE = "MODULE";
            public static final String CREATED = "CREATED";
            public static final String UPDATED = "UPDATED";
            public static final String MIGRATED_KEY = "MIGRATED_KEY";
        }
    }
}

