/*
 * Decompiled with CFR 0.152.
 */
package net.grandcentrix.tray.provider;

import android.content.ContentValues;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SqliteHelper {
    public static String extendSelection(@Nullable String selection, @Nullable String selectionToAdd) {
        if (!TextUtils.isEmpty((CharSequence)selection)) {
            if (TextUtils.isEmpty((CharSequence)selectionToAdd)) {
                return selection;
            }
            StringBuilder selectionToAddBuilder = new StringBuilder();
            selection = selectionToAddBuilder.append("(").append(selection).append(") AND (").append(selectionToAdd).append(")").toString();
        } else {
            selection = selectionToAdd;
        }
        return selection;
    }

    public static String[] extendSelectionArgs(@Nullable String[] selectionArgs, @Nullable String[] newSelectionArgs) {
        if (newSelectionArgs == null) {
            return selectionArgs;
        }
        return SqliteHelper.extendSelectionArgs(selectionArgs, Arrays.asList(newSelectionArgs));
    }

    public static String[] extendSelectionArgs(@Nullable String[] selectionArgs, @Nullable List<String> newSelectionArgs) {
        if (newSelectionArgs == null) {
            return selectionArgs;
        }
        if (selectionArgs != null) {
            ArrayList<String> selectionArgList = new ArrayList<String>(Arrays.asList(selectionArgs));
            selectionArgList.addAll(newSelectionArgs);
            selectionArgs = selectionArgList.toArray(new String[selectionArgList.size()]);
        } else {
            selectionArgs = newSelectionArgs.toArray(new String[newSelectionArgs.size()]);
        }
        return selectionArgs;
    }

    public static String[] extendSelectionArgs(@Nullable String selectionArg, @Nullable String[] newSelectionArgs) {
        if (TextUtils.isEmpty((CharSequence)selectionArg)) {
            return newSelectionArgs;
        }
        return SqliteHelper.extendSelectionArgs(new String[]{selectionArg}, newSelectionArgs);
    }

    public static int insertOrUpdate(@Nullable SQLiteDatabase sqlDb, String table, @Nullable String selection, String[] selectionArgs, @NonNull ContentValues values, @Nullable String[] excludeFieldsForUpdate) {
        if (sqlDb == null) {
            return -1;
        }
        long items = DatabaseUtils.queryNumEntries((SQLiteDatabase)sqlDb, (String)table, (String)selection, (String[])selectionArgs);
        if (items == 0L) {
            long row = sqlDb.insert(table, null, values);
            if (row == -1L) {
                return -1;
            }
            return 1;
        }
        if (excludeFieldsForUpdate != null) {
            for (String excludeField : excludeFieldsForUpdate) {
                values.remove(excludeField);
            }
        }
        sqlDb.update(table, values, selection, selectionArgs);
        return 0;
    }
}

