/*
 * Decompiled with CFR 0.152.
 */
package net.grandcentrix.tray.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import net.grandcentrix.tray.core.ItemNotFoundException;
import net.grandcentrix.tray.core.OnTrayPreferenceChangeListener;
import net.grandcentrix.tray.core.Preferences;
import net.grandcentrix.tray.core.TrayItem;
import net.grandcentrix.tray.core.TrayLog;
import net.grandcentrix.tray.core.TrayStorage;
import net.grandcentrix.tray.core.WrongTypeException;

public abstract class AbstractTrayPreference<T extends TrayStorage>
extends Preferences<TrayItem, T> {
    protected AbstractTrayPreference(@NonNull T storage, int version) {
        super(storage, version);
    }

    @Override
    public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (ItemNotFoundException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(@NonNull String key) throws ItemNotFoundException {
        String value = this.getString(key);
        return Boolean.parseBoolean(value);
    }

    @Override
    public float getFloat(@NonNull String key, float defaultValue) {
        try {
            return this.getFloat(key);
        }
        catch (ItemNotFoundException e) {
            return defaultValue;
        }
    }

    @Override
    public float getFloat(@NonNull String key) throws ItemNotFoundException {
        String value = this.getString(key);
        this.throwForNullValue(value, Float.class, key);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new WrongTypeException(e);
        }
    }

    @Override
    public int getInt(@NonNull String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (ItemNotFoundException e) {
            return defaultValue;
        }
    }

    @Override
    public int getInt(@NonNull String key) throws ItemNotFoundException {
        String value = this.getString(key);
        this.throwForNullValue(value, Integer.class, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new WrongTypeException(e);
        }
    }

    @Override
    public long getLong(@NonNull String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (ItemNotFoundException e) {
            return defaultValue;
        }
    }

    @Override
    public long getLong(@NonNull String key) throws ItemNotFoundException {
        String value = this.getString(key);
        this.throwForNullValue(value, Long.class, key);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new WrongTypeException(e);
        }
    }

    public String getName() {
        return ((TrayStorage)this.getStorage()).getModuleName();
    }

    @Override
    public String getString(@NonNull String key) throws ItemNotFoundException {
        TrayItem pref = (TrayItem)this.getPref(key);
        if (pref == null) {
            throw new ItemNotFoundException("Value for Key <%s> not found", key);
        }
        return pref.value();
    }

    @Override
    @Nullable
    public String getString(@NonNull String key, String defaultValue) {
        try {
            return this.getString(key);
        }
        catch (ItemNotFoundException e) {
            return defaultValue;
        }
    }

    public void registerOnTrayPreferenceChangeListener(@NonNull OnTrayPreferenceChangeListener listener) {
        ((TrayStorage)this.getStorage()).registerOnTrayPreferenceChangeListener(listener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(@" + Integer.toHexString(this.hashCode()) + "){name=" + this.getName() + "}";
    }

    public void unregisterOnTrayPreferenceChangeListener(@NonNull OnTrayPreferenceChangeListener listener) {
        ((TrayStorage)this.getStorage()).unregisterOnTrayPreferenceChangeListener(listener);
    }

    protected void annex(T oldStorage) {
        ((TrayStorage)this.getStorage()).annex((TrayStorage)oldStorage);
        TrayLog.v("annexed " + oldStorage + " to " + this);
    }

    private void throwForNullValue(@Nullable String value, Class<?> clazz, @NonNull String key) throws WrongTypeException {
        if (value == null) {
            throw new WrongTypeException("The value for key <" + key + "> is null. You obviously saved this value as String and try to access it with type " + clazz.getSimpleName() + " which cannot be null.  Always use getString(key, defaultValue) when accessing data you saved with put(String).");
        }
    }
}

