/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.redis;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.plugin.redis.Cache;
import com.jfinal.plugin.redis.Redis;
import redis.clients.jedis.Jedis;

public class RedisInterceptor
implements Interceptor {
    protected Cache getCache() {
        return Redis.use();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(Invocation inv) {
        Cache cache = this.getCache();
        Jedis jedis = cache.getThreadLocalJedis();
        if (jedis != null) {
            inv.invoke();
            return;
        }
        try {
            jedis = cache.jedisPool.getResource();
            cache.setThreadLocalJedis(jedis);
            inv.invoke();
        }
        finally {
            cache.removeThreadLocalJedis();
            jedis.close();
        }
    }
}

