/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.users.response;

import com.jelastic.api.Response;
import com.jelastic.api.data.po.SessionDTO;
import com.jelastic.api.json.JSONSerializable;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionsResponse
extends Response
implements JSONSerializable {
    private static final String SESSIONS = "sessions";
    private Set<SessionDTO> sessions;

    public SessionsResponse() {
        super(0);
    }

    public SessionsResponse(Set<SessionDTO> sessions) {
        super(0);
        this.sessions = sessions;
    }

    public SessionsResponse(int result, String error) {
        super(result, error);
    }

    public SessionsResponse(Response resp) {
        this.setResult(resp.getResult());
        this.setError(resp.getError());
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        try {
            JSONArray jsonArray = new JSONArray();
            for (SessionDTO session : this.sessions) {
                jsonArray.put((Object)session.toJSON());
            }
            json.put(SESSIONS, (Object)jsonArray);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                json.put("result", 99).put("error", (Object)ex.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return json;
    }

    @Override
    public SessionsResponse fromJSON(JSONObject json) {
        try {
            if (json.has(SESSIONS) && !json.isNull(SESSIONS)) {
                JSONArray jsonArray = json.getJSONArray(SESSIONS);
                if (this.sessions == null) {
                    this.sessions = new HashSet<SessionDTO>(jsonArray.length());
                }
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    SessionDTO sessionDTO = new SessionDTO();
                    sessionDTO.fromJSON(jsonObject);
                    this.sessions.add(sessionDTO);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                json.put("result", 99).put("error", (Object)ex.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return this;
    }
}

