/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.users.response;

import com.jelastic.api.Response;
import com.jelastic.api.development.persistence.User;
import com.jelastic.api.json.JSONSerializable;
import com.jelastic.api.system.persistence.AccessType;
import com.jelastic.api.system.persistence.AuthType;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticationResponse
extends Response
implements JSONSerializable {
    public static final String DATA_LANGUAGE_KEY = "lang";
    private static final String AUTH_TYPE = "type";
    private static final String AUTH_CONFIG = "authConfig";
    private static final String ACCESS_TYPE = "accessType";
    private String session = null;
    private String name = null;
    private String email = null;
    private int uid = -1;
    private Map<String, String> data;
    private AuthType authType = AuthType.BASIC;
    private AccessType accessType;

    public AuthenticationResponse() {
        super(0);
    }

    public AuthenticationResponse(User user) {
        super(0);
        this.setUid(user.getId());
        this.setName(user.getName());
        this.setEmail(user.getEmail());
    }

    public AuthenticationResponse(Response resp) {
        this.setResult(resp.getResult());
        this.setError(resp.getError());
    }

    public AuthenticationResponse(int uid) {
        super(0);
        this.uid = uid;
    }

    public AuthenticationResponse(String session) {
        super(0);
        this.session = session;
    }

    public AuthenticationResponse(int result, String error) {
        super(result, error);
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(Object pid) {
        this.setSession(pid == null ? null : (String)pid);
    }

    @Deprecated
    public String getSessionPid() {
        return this.getSession();
    }

    public void setSession(String pid) {
        this.session = pid;
    }

    @Deprecated
    public void setSessionPid(Object pid) {
        this.setSession(pid);
    }

    @Deprecated
    public void setSessionPid(String pid) {
        this.setSession(pid);
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        try {
            if (this.getName() != null) {
                json.put("name", (Object)this.getName());
            }
            if (this.getEmail() != null) {
                json.put("email", (Object)this.getEmail());
            }
            if (this.getSession() != null) {
                json.put("session", (Object)this.getSession());
            }
            if (this.getUid() > -1) {
                json.put("uid", this.getUid());
            }
            if (this.getData() != null) {
                json.put("data", this.getData());
            }
            JSONObject authConfigJson = new JSONObject();
            authConfigJson.put(AUTH_TYPE, (Object)this.authType);
            json.put(AUTH_CONFIG, (Object)authConfigJson);
            json.put(ACCESS_TYPE, (Object)this.getAccessType());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                json.put("result", 99).put("error", (Object)ex.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return json;
    }

    @Override
    public AuthenticationResponse _fromJSON(JSONObject json) throws JSONException {
        JSONObject authConfigJson;
        super._fromJSON(json);
        if (json.has("name")) {
            this.name = json.getString("name");
        }
        if (json.has("email")) {
            this.email = json.getString("email");
        }
        if (json.has("session")) {
            this.session = json.getString("session");
        }
        if (json.has("uid")) {
            this.uid = json.getInt("uid");
        }
        if (json.has("data")) {
            JSONObject jsonData = json.getJSONObject("data");
            this.data = new HashMap<String, String>();
            if (jsonData.has(DATA_LANGUAGE_KEY)) {
                this.data.put(DATA_LANGUAGE_KEY, jsonData.getString(DATA_LANGUAGE_KEY));
            }
        }
        if (json.has(AUTH_CONFIG) && (authConfigJson = json.getJSONObject(AUTH_CONFIG)).has(AUTH_TYPE)) {
            this.authType = AuthType.get(authConfigJson.getString(AUTH_TYPE));
        }
        if (json.has(ACCESS_TYPE)) {
            this.accessType = AccessType.valueOf(json.getString(ACCESS_TYPE).toUpperCase());
        }
        return this;
    }
}

