/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.users;

import com.jelastic.api.AbstractService;
import com.jelastic.api.Callback;
import com.jelastic.api.Response;
import com.jelastic.api.client.annotation.JelasticModuleName;
import com.jelastic.api.users.response.ApiTokenPermissionsResponse;
import com.jelastic.api.users.response.ApiTokenResponse;
import com.jelastic.api.users.response.ApiTokenTemplatesResponse;
import com.jelastic.api.users.response.ApiTokensResponse;
import com.jelastic.api.users.response.AuthenticationResponse;
import com.jelastic.api.users.response.SessionsResponse;
import java.util.HashMap;
import java.util.Map;

@JelasticModuleName(name="hcore")
public class Authentication
extends AbstractService {
    public static String SERVICE_PATH = "users/authentication/";
    private String serviceUrl = SERVER_URL + SERVICE_PATH;
    private String appid = null;
    private String session = null;
    private String client_source = null;

    public Authentication() {
    }

    public Authentication(Map _params) {
        this((String)_params.get("appid"), (String)_params.get("session"), (String)_params.get("serviceUrl"));
        String serverUrl = (String)_params.get("serverUrl");
        if (serverUrl != null) {
            this.setServerUrl(serverUrl);
        }
    }

    public Authentication(String appid, String session, String serviceUrl) {
        if (appid != null) {
            this.appid = appid;
        }
        if (session != null) {
            this.session = session;
        }
        if (serviceUrl != null) {
            this.serviceUrl = serviceUrl;
        }
    }

    public Authentication(String appid, String session) {
        this(appid, session, null);
    }

    public Authentication(String appid) {
        this(appid, null, null);
    }

    public String getAppid() {
        return this.appid;
    }

    public Authentication setAppid(String appid) {
        this.appid = appid;
        return this;
    }

    public String getSession() {
        return this.session;
    }

    public Authentication setSession(String session) {
        this.session = session;
        return this;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public Authentication setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String getServerUrl() {
        return this.serviceUrl;
    }

    public Authentication setServerUrl(String serverUrl) {
        this.serviceUrl = serverUrl + SERVICE_PATH;
        return this;
    }

    public Authentication setClientSource(String client_source) {
        this.client_source = client_source;
        return this;
    }

    public String getClientSource() {
        return this.client_source;
    }

    public AuthenticationResponse signin(String appid, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (AuthenticationResponse)this._call(appid, this.serviceUrl + "rest/signin", _params, AuthenticationResponse.class);
    }

    public AuthenticationResponse signin(String appid, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (AuthenticationResponse)this._call(appid, this.serviceUrl + "rest/signin", _params, headers, AuthenticationResponse.class);
    }

    public Authentication signin(final String appid, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AuthenticationResponse response = Authentication.this.signin(appid, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication signin(final String appid, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AuthenticationResponse response = Authentication.this.signin(appid, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public AuthenticationResponse signin(String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (AuthenticationResponse)this._call(this.appid, this.serviceUrl + "rest/signin", _params, AuthenticationResponse.class);
    }

    public AuthenticationResponse signin(String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (AuthenticationResponse)this._call(this.appid, this.serviceUrl + "rest/signin", _params, headers, AuthenticationResponse.class);
    }

    public Authentication signin(final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AuthenticationResponse response = Authentication.this.signin(login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication signin(final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AuthenticationResponse response = Authentication.this.signin(login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public AuthenticationResponse signin(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (AuthenticationResponse)this._call(this.appid, this.serviceUrl + "rest/signin", _params, AuthenticationResponse.class);
    }

    public AuthenticationResponse signin(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (AuthenticationResponse)this._call(this.appid, this.serviceUrl + "rest/signin", _params, headers, AuthenticationResponse.class);
    }

    public Response signout(String appid, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(appid, this.serviceUrl + "rest/signout", _params, Response.class);
    }

    public Response signout(String appid, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(appid, this.serviceUrl + "rest/signout", _params, headers, Response.class);
    }

    public Authentication signout(final String appid, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signout(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication signout(final String appid, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signout(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response signout(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signout", _params, Response.class);
    }

    public Response signout(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signout", _params, headers, Response.class);
    }

    public Authentication signout(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signout(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication signout(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signout(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response signout() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signout", _params, Response.class);
    }

    public Authentication signout(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signout();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response signout(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signout", _params, Response.class);
    }

    public Response signout(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signout", _params, headers, Response.class);
    }

    public ApiTokenResponse createToken(String appid, String session, String password, String description, String tokenTemplate, String apiList, String expiresAt, Boolean isProtected) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("apiList", apiList);
        _params.put("expiresAt", expiresAt);
        _params.put("isProtected", isProtected + "");
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/createtoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse createToken(String appid, String session, String password, String description, String tokenTemplate, String apiList, String expiresAt, Boolean isProtected, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("apiList", apiList);
        _params.put("expiresAt", expiresAt);
        _params.put("isProtected", isProtected + "");
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/createtoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication createToken(final String appid, final String session, final String password, final String description, final String tokenTemplate, final String apiList, final String expiresAt, final Boolean isProtected, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.createToken(appid, session, password, description, tokenTemplate, apiList, expiresAt, isProtected);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication createToken(final String appid, final String session, final String password, final String description, final String tokenTemplate, final String apiList, final String expiresAt, final Boolean isProtected, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.createToken(appid, session, password, description, tokenTemplate, apiList, expiresAt, isProtected);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse createToken(String appid, String session, String password, String description, String tokenTemplate, String apiList, String expiresAt) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("apiList", apiList);
        _params.put("expiresAt", expiresAt);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/createtoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse createToken(String appid, String session, String password, String description, String tokenTemplate, String apiList, String expiresAt, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("apiList", apiList);
        _params.put("expiresAt", expiresAt);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/createtoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication createToken(final String appid, final String session, final String password, final String description, final String tokenTemplate, final String apiList, final String expiresAt, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.createToken(appid, session, password, description, tokenTemplate, apiList, expiresAt);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication createToken(final String appid, final String session, final String password, final String description, final String tokenTemplate, final String apiList, final String expiresAt, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.createToken(appid, session, password, description, tokenTemplate, apiList, expiresAt);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse createToken(String appid, String session, String password, String description, String tokenTemplate) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/createtoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse createToken(String appid, String session, String password, String description, String tokenTemplate, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/createtoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication createToken(final String appid, final String session, final String password, final String description, final String tokenTemplate, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.createToken(appid, session, password, description, tokenTemplate);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication createToken(final String appid, final String session, final String password, final String description, final String tokenTemplate, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.createToken(appid, session, password, description, tokenTemplate);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse createToken(String appid, String session, String password, String description) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("description", description);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/createtoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse createToken(String appid, String session, String password, String description, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("description", description);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/createtoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication createToken(final String appid, final String session, final String password, final String description, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.createToken(appid, session, password, description);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication createToken(final String appid, final String session, final String password, final String description, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.createToken(appid, session, password, description);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse createToken(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenResponse)this._call(this.appid, this.serviceUrl + "rest/createtoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse createToken(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenResponse)this._call(this.appid, this.serviceUrl + "rest/createtoken", _params, headers, ApiTokenResponse.class);
    }

    public Response deleteTokens(String appid, String session, String ids, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("ids", ids);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(appid, this.serviceUrl + "rest/deletetokens", _params, Response.class);
    }

    public Response deleteTokens(String appid, String session, String ids, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("ids", ids);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(appid, this.serviceUrl + "rest/deletetokens", _params, headers, Response.class);
    }

    public Authentication deleteTokens(final String appid, final String session, final String ids, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.deleteTokens(appid, session, ids, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication deleteTokens(final String appid, final String session, final String ids, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.deleteTokens(appid, session, ids, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response deleteTokens(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deletetokens", _params, Response.class);
    }

    public Response deleteTokens(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deletetokens", _params, headers, Response.class);
    }

    public ApiTokenResponse regenerateToken(String appid, String session, int id, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/regeneratetoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse regenerateToken(String appid, String session, int id, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/regeneratetoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication regenerateToken(final String appid, final String session, final int id, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.regenerateToken(appid, session, id, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication regenerateToken(final String appid, final String session, final int id, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.regenerateToken(appid, session, id, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse regenerateToken(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenResponse)this._call(this.appid, this.serviceUrl + "rest/regeneratetoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse regenerateToken(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenResponse)this._call(this.appid, this.serviceUrl + "rest/regeneratetoken", _params, headers, ApiTokenResponse.class);
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password, String description, String tokenTemplate, String apiList, String expiresAt) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("apiList", apiList);
        _params.put("expiresAt", expiresAt);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password, String description, String tokenTemplate, String apiList, String expiresAt, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("apiList", apiList);
        _params.put("expiresAt", expiresAt);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, final String description, final String tokenTemplate, final String apiList, final String expiresAt, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password, description, tokenTemplate, apiList, expiresAt);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, final String description, final String tokenTemplate, final String apiList, final String expiresAt, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password, description, tokenTemplate, apiList, expiresAt);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password, String description, String tokenTemplate, String apiList) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("apiList", apiList);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password, String description, String tokenTemplate, String apiList, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("apiList", apiList);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, final String description, final String tokenTemplate, final String apiList, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password, description, tokenTemplate, apiList);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, final String description, final String tokenTemplate, final String apiList, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password, description, tokenTemplate, apiList);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password, String description, String tokenTemplate) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password, String description, String tokenTemplate, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("description", description);
        _params.put("tokenTemplate", tokenTemplate);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, final String description, final String tokenTemplate, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password, description, tokenTemplate);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, final String description, final String tokenTemplate, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password, description, tokenTemplate);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password, String description) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("description", description);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password, String description, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("description", description);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, final String description, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password, description);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, final String description, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password, description);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse editToken(String appid, String session, int id, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ApiTokenResponse)this._call(appid, this.serviceUrl + "rest/edittoken", _params, headers, ApiTokenResponse.class);
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication editToken(final String appid, final String session, final int id, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenResponse response = Authentication.this.editToken(appid, session, id, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenResponse editToken(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenResponse)this._call(this.appid, this.serviceUrl + "rest/edittoken", _params, ApiTokenResponse.class);
    }

    public ApiTokenResponse editToken(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenResponse)this._call(this.appid, this.serviceUrl + "rest/edittoken", _params, headers, ApiTokenResponse.class);
    }

    public ApiTokensResponse getTokens(String appid, String session, String ids) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("ids", ids);
        _params.put("client_source", this.client_source);
        return (ApiTokensResponse)this._call(appid, this.serviceUrl + "rest/gettokens", _params, ApiTokensResponse.class);
    }

    public ApiTokensResponse getTokens(String appid, String session, String ids, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("ids", ids);
        _params.put("client_source", this.client_source);
        return (ApiTokensResponse)this._call(appid, this.serviceUrl + "rest/gettokens", _params, headers, ApiTokensResponse.class);
    }

    public Authentication getTokens(final String appid, final String session, final String ids, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokensResponse response = Authentication.this.getTokens(appid, session, ids);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication getTokens(final String appid, final String session, final String ids, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokensResponse response = Authentication.this.getTokens(appid, session, ids);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokensResponse getTokens(String appid, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ApiTokensResponse)this._call(appid, this.serviceUrl + "rest/gettokens", _params, ApiTokensResponse.class);
    }

    public ApiTokensResponse getTokens(String appid, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ApiTokensResponse)this._call(appid, this.serviceUrl + "rest/gettokens", _params, headers, ApiTokensResponse.class);
    }

    public Authentication getTokens(final String appid, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokensResponse response = Authentication.this.getTokens(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication getTokens(final String appid, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokensResponse response = Authentication.this.getTokens(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokensResponse getTokens(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokensResponse)this._call(this.appid, this.serviceUrl + "rest/gettokens", _params, ApiTokensResponse.class);
    }

    public ApiTokensResponse getTokens(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokensResponse)this._call(this.appid, this.serviceUrl + "rest/gettokens", _params, headers, ApiTokensResponse.class);
    }

    public ApiTokenPermissionsResponse getTokenApiList(String appid, String session, boolean showPrivate, String sortParam) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("showPrivate", showPrivate + "");
        _params.put("sortParam", sortParam);
        _params.put("client_source", this.client_source);
        return (ApiTokenPermissionsResponse)this._call(appid, this.serviceUrl + "rest/gettokenapilist", _params, ApiTokenPermissionsResponse.class);
    }

    public ApiTokenPermissionsResponse getTokenApiList(String appid, String session, boolean showPrivate, String sortParam, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("showPrivate", showPrivate + "");
        _params.put("sortParam", sortParam);
        _params.put("client_source", this.client_source);
        return (ApiTokenPermissionsResponse)this._call(appid, this.serviceUrl + "rest/gettokenapilist", _params, headers, ApiTokenPermissionsResponse.class);
    }

    public Authentication getTokenApiList(final String appid, final String session, final boolean showPrivate, final String sortParam, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenPermissionsResponse response = Authentication.this.getTokenApiList(appid, session, showPrivate, sortParam);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication getTokenApiList(final String appid, final String session, final boolean showPrivate, final String sortParam, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenPermissionsResponse response = Authentication.this.getTokenApiList(appid, session, showPrivate, sortParam);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenPermissionsResponse getTokenApiList(String appid, String session, boolean showPrivate) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("showPrivate", showPrivate + "");
        _params.put("client_source", this.client_source);
        return (ApiTokenPermissionsResponse)this._call(appid, this.serviceUrl + "rest/gettokenapilist", _params, ApiTokenPermissionsResponse.class);
    }

    public ApiTokenPermissionsResponse getTokenApiList(String appid, String session, boolean showPrivate, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("showPrivate", showPrivate + "");
        _params.put("client_source", this.client_source);
        return (ApiTokenPermissionsResponse)this._call(appid, this.serviceUrl + "rest/gettokenapilist", _params, headers, ApiTokenPermissionsResponse.class);
    }

    public Authentication getTokenApiList(final String appid, final String session, final boolean showPrivate, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenPermissionsResponse response = Authentication.this.getTokenApiList(appid, session, showPrivate);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication getTokenApiList(final String appid, final String session, final boolean showPrivate, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenPermissionsResponse response = Authentication.this.getTokenApiList(appid, session, showPrivate);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenPermissionsResponse getTokenApiList(String appid, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ApiTokenPermissionsResponse)this._call(appid, this.serviceUrl + "rest/gettokenapilist", _params, ApiTokenPermissionsResponse.class);
    }

    public ApiTokenPermissionsResponse getTokenApiList(String appid, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ApiTokenPermissionsResponse)this._call(appid, this.serviceUrl + "rest/gettokenapilist", _params, headers, ApiTokenPermissionsResponse.class);
    }

    public Authentication getTokenApiList(final String appid, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenPermissionsResponse response = Authentication.this.getTokenApiList(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication getTokenApiList(final String appid, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenPermissionsResponse response = Authentication.this.getTokenApiList(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenPermissionsResponse getTokenApiList(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenPermissionsResponse)this._call(this.appid, this.serviceUrl + "rest/gettokenapilist", _params, ApiTokenPermissionsResponse.class);
    }

    public ApiTokenPermissionsResponse getTokenApiList(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenPermissionsResponse)this._call(this.appid, this.serviceUrl + "rest/gettokenapilist", _params, headers, ApiTokenPermissionsResponse.class);
    }

    public ApiTokenTemplatesResponse getTokenTemplates(String appid, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ApiTokenTemplatesResponse)this._call(appid, this.serviceUrl + "rest/gettokentemplates", _params, ApiTokenTemplatesResponse.class);
    }

    public ApiTokenTemplatesResponse getTokenTemplates(String appid, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ApiTokenTemplatesResponse)this._call(appid, this.serviceUrl + "rest/gettokentemplates", _params, headers, ApiTokenTemplatesResponse.class);
    }

    public Authentication getTokenTemplates(final String appid, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenTemplatesResponse response = Authentication.this.getTokenTemplates(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication getTokenTemplates(final String appid, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ApiTokenTemplatesResponse response = Authentication.this.getTokenTemplates(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ApiTokenTemplatesResponse getTokenTemplates(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenTemplatesResponse)this._call(this.appid, this.serviceUrl + "rest/gettokentemplates", _params, ApiTokenTemplatesResponse.class);
    }

    public ApiTokenTemplatesResponse getTokenTemplates(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ApiTokenTemplatesResponse)this._call(this.appid, this.serviceUrl + "rest/gettokentemplates", _params, headers, ApiTokenTemplatesResponse.class);
    }

    public SessionsResponse getSessions(String appid, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (SessionsResponse)this._call(appid, this.serviceUrl + "rest/getsessions", _params, SessionsResponse.class);
    }

    public SessionsResponse getSessions(String appid, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (SessionsResponse)this._call(appid, this.serviceUrl + "rest/getsessions", _params, headers, SessionsResponse.class);
    }

    public Authentication getSessions(final String appid, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SessionsResponse response = Authentication.this.getSessions(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication getSessions(final String appid, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SessionsResponse response = Authentication.this.getSessions(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public SessionsResponse getSessions(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (SessionsResponse)this._call(this.appid, this.serviceUrl + "rest/getsessions", _params, SessionsResponse.class);
    }

    public SessionsResponse getSessions(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (SessionsResponse)this._call(this.appid, this.serviceUrl + "rest/getsessions", _params, headers, SessionsResponse.class);
    }

    public Authentication getSessions(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SessionsResponse response = Authentication.this.getSessions(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication getSessions(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SessionsResponse response = Authentication.this.getSessions(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public SessionsResponse getSessions() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (SessionsResponse)this._call(this.appid, this.serviceUrl + "rest/getsessions", _params, SessionsResponse.class);
    }

    public Authentication getSessions(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SessionsResponse response = Authentication.this.getSessions();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public SessionsResponse getSessions(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (SessionsResponse)this._call(this.appid, this.serviceUrl + "rest/getsessions", _params, SessionsResponse.class);
    }

    public SessionsResponse getSessions(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (SessionsResponse)this._call(this.appid, this.serviceUrl + "rest/getsessions", _params, headers, SessionsResponse.class);
    }

    public Response signoutSessions(String appid, String session, String ids) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("ids", ids);
        _params.put("client_source", this.client_source);
        return (Response)this._call(appid, this.serviceUrl + "rest/signoutsessions", _params, Response.class);
    }

    public Response signoutSessions(String appid, String session, String ids, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("ids", ids);
        _params.put("client_source", this.client_source);
        return (Response)this._call(appid, this.serviceUrl + "rest/signoutsessions", _params, headers, Response.class);
    }

    public Authentication signoutSessions(final String appid, final String session, final String ids, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signoutSessions(appid, session, ids);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication signoutSessions(final String appid, final String session, final String ids, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signoutSessions(appid, session, ids);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response signoutSessions(String session, String ids) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("ids", ids);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signoutsessions", _params, Response.class);
    }

    public Response signoutSessions(String session, String ids, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("ids", ids);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signoutsessions", _params, headers, Response.class);
    }

    public Authentication signoutSessions(final String session, final String ids, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signoutSessions(session, ids);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication signoutSessions(final String session, final String ids, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signoutSessions(session, ids);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response signoutSessions(String ids) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("ids", ids);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signoutsessions", _params, Response.class);
    }

    public Response signoutSessions(String ids, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("ids", ids);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signoutsessions", _params, headers, Response.class);
    }

    public Authentication signoutSessions(final String ids, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signoutSessions(ids);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Authentication signoutSessions(final String ids, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Authentication.this.signoutSessions(ids);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response signoutSessions(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signoutsessions", _params, Response.class);
    }

    public Response signoutSessions(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/signoutsessions", _params, headers, Response.class);
    }
}

