/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.system.statistic.persistence;

import com.jelastic.api.core.utils.DateUtils;
import com.jelastic.api.system.statistic.persistence.AbstractStatEntity;
import java.text.ParseException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class StatElement
extends AbstractStatEntity
implements Comparable<StatElement> {
    public static final String CPU_MHZ = "cpumhz";
    public static final String CPU = "cpu";
    public static final String NET = "net";
    public static final String NET_IN_INT = "in_int";
    public static final String NET_OUT_INT = "out_int";
    public static final String NET_IN_EXT = "in_ext";
    public static final String NET_OUT_EXT = "out_ext";
    public static final String MEM = "mem";
    public static final String DISK = "disk";
    public static final String DURATION = "duration";
    public static final String START = "start";
    public static final String IOPS_USED = "iops_used";
    public static final String IOPS_LIMIT = "iops_limit";
    public static final String CAPACITY = "capacity";
    public static final String CHANKUSED = "chanksused";
    public static final String CLOUDLETUSED = "cloudletsused";
    public static final String DISK_IO_USED = "disk_io_used";
    public static final String DISK_IO_LIMIT = "disk_io_limit";
    private int id = 0x6400000;
    private Date startTime;
    private int duration;
    private Integer cpuUsed;
    private Integer memUsed;
    private Integer diskUsed;
    private Long netIn_int;
    private Long netOut_int;
    private Long netIn_ext;
    private Long netOut_ext;
    private Integer chanksUsed = -1;
    private Integer cloudletsUsed = -1;
    private Integer cpuMHz;
    private int capacity;
    private Integer diskIopsUsed;
    private Integer diskIopsLimit;
    private Integer diskIoUsed;
    private Integer diskIoLimit;

    public StatElement(int duration, Integer cpuUsed, Integer memUsed, Integer diskUsed, Long netIn_int, Long netOut_int, Long netIn_ext, Long netOut_ext, Integer diskIoUsed) {
        this.duration = duration;
        this.cpuUsed = cpuUsed;
        this.memUsed = memUsed;
        this.diskUsed = diskUsed;
        this.netIn_int = netIn_int;
        this.netOut_int = netOut_int;
        this.netIn_ext = netIn_ext;
        this.netOut_ext = netOut_ext;
        this.diskIoUsed = diskIoUsed;
    }

    public StatElement(Date startTime, int duration, Integer cpuUsed, Integer memUsed, Integer diskUsed, Long netIn_int, Long netOut_int, Long netIn_ext, Long netOut_ext, Integer diskIoUsed) {
        this(duration, cpuUsed, memUsed, diskUsed, netIn_int, netOut_int, netIn_ext, netOut_ext, diskIoUsed);
        this.startTime = startTime;
    }

    public StatElement() {
        this.cpuUsed = 0;
        this.memUsed = 0;
        this.diskUsed = 0;
        this.netIn_int = 0L;
        this.netOut_int = 0L;
        this.netIn_ext = 0L;
        this.netOut_ext = 0L;
        this.diskIoUsed = 0;
    }

    public Integer getDiskIoUsed() {
        return this.diskIoUsed;
    }

    public void setDiskIoUsed(Integer diskIoUsed) {
        this.diskIoUsed = diskIoUsed;
    }

    public int getCpuUsed() {
        return this.cpuUsed;
    }

    public void setCpuUsed(int cpuUsed) {
        this.cpuUsed = cpuUsed;
    }

    public int getDiskUsed() {
        return this.diskUsed;
    }

    public void setDiskUsed(int diskUsed) {
        this.diskUsed = diskUsed;
    }

    public Integer getDiskIopsUsed() {
        return this.diskIopsUsed;
    }

    public void setDiskIopsUsed(Integer diskIopsUsed) {
        this.diskIopsUsed = diskIopsUsed;
    }

    public Integer getDiskIopsLimit() {
        return this.diskIopsLimit;
    }

    public void setDiskIopsLimit(Integer diskIopsLimit) {
        this.diskIopsLimit = diskIopsLimit;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getMemUsed() {
        return this.memUsed;
    }

    public void setMemUsed(int memUsed) {
        this.memUsed = memUsed;
    }

    public Long getNetInInt() {
        return this.netIn_int;
    }

    public Long getNetInExt() {
        return this.netIn_ext;
    }

    public void setNetInInt(Long netIn_int) {
        this.netIn_int = netIn_int;
    }

    public void setNetInExt(Long netIn_ext) {
        this.netIn_ext = netIn_ext;
    }

    public void addNetInInt(Long netIn_int) {
        if (this.netIn_int == null) {
            this.setNetInInt(netIn_int);
        } else {
            StatElement statElement = this;
            statElement.netIn_int = statElement.netIn_int + netIn_int;
        }
    }

    public void addNetIn(Long netIn_ext) {
        if (this.netIn_ext == null) {
            this.setNetInExt(netIn_ext);
        } else {
            StatElement statElement = this;
            statElement.netIn_ext = statElement.netIn_ext + netIn_ext;
        }
    }

    public Long getNetOutInt() {
        return this.netOut_int;
    }

    public Long getNetOutExt() {
        return this.netOut_ext;
    }

    public void setNetOutInt(Long netOut_int) {
        this.netOut_int = netOut_int;
    }

    public void setNetOutExt(Long netOut_ext) {
        this.netOut_ext = netOut_ext;
    }

    public void addNetOutInt(Long netOut_int) {
        if (this.netOut_int == null) {
            this.setNetOutInt(netOut_int);
        } else {
            StatElement statElement = this;
            statElement.netOut_int = statElement.netOut_int + netOut_int;
        }
    }

    public void addNetOutExt(Long netOut_ext) {
        if (this.netOut_ext == null) {
            this.setNetOutExt(netOut_ext);
        } else {
            StatElement statElement = this;
            statElement.netOut_ext = statElement.netOut_ext + netOut_ext;
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Integer getChanksUsed() {
        return this.chanksUsed;
    }

    public void setChanksUsed(Integer chanksUsed) {
        this.chanksUsed = chanksUsed;
    }

    public Integer getCloudletsUsed() {
        return this.cloudletsUsed;
    }

    public void setCloudletsUsed(Integer cloudletsUsed) {
        this.cloudletsUsed = cloudletsUsed;
    }

    public Integer getCpuMHz() {
        if (this.cpuMHz == null) {
            this.cpuMHz = 0;
            if (this.cpuUsed != null && this.duration > 0) {
                this.cpuMHz = Math.round((float)this.cpuUsed.intValue() / (float)this.duration);
            }
        }
        return this.cpuMHz;
    }

    public void setCpuMHz(Integer cpuMHz) {
        this.cpuMHz = cpuMHz;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public boolean isCompleted() {
        return this.cpuUsed != null && this.memUsed != null && this.diskUsed != null && this.netIn_int != null && this.netOut_int != null && this.netIn_ext != null && this.netOut_ext != null && this.diskIopsUsed != null && this.diskIoUsed != null;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = super._toJSON();
        json.put(CPU_MHZ, (Object)this.getCpuMHz());
        if (this.cpuUsed != null) {
            json.put(CPU, (Object)this.cpuUsed);
        } else {
            json.put(CPU, 0);
        }
        if (this.memUsed != null) {
            json.put(MEM, (Object)this.memUsed);
        } else {
            json.put(MEM, 0);
        }
        if (this.chanksUsed == null) {
            json.put(CHANKUSED, 0);
            json.put(CLOUDLETUSED, 0);
        } else if (this.chanksUsed != -1) {
            json.put(CHANKUSED, (Object)this.chanksUsed);
            json.put(CLOUDLETUSED, (Object)this.cloudletsUsed);
        }
        json.put(CAPACITY, this.capacity);
        if (this.diskUsed != null) {
            json.put(DISK, (Object)this.diskUsed);
        } else {
            json.put(DISK, 0);
        }
        if (this.diskIopsUsed != null) {
            json.put(IOPS_USED, (Object)this.diskIopsUsed);
        } else {
            json.put(IOPS_USED, 0);
        }
        if (this.diskIopsLimit != null) {
            json.put(IOPS_LIMIT, (Object)this.diskIopsLimit);
        } else {
            json.put(IOPS_LIMIT, 0);
        }
        JSONObject netJson = new JSONObject();
        if (this.netIn_int != null) {
            netJson.put(NET_IN_INT, (Object)this.netIn_int);
        } else {
            netJson.put(NET_IN_INT, 0);
        }
        if (this.netOut_int != null) {
            netJson.put(NET_OUT_INT, (Object)this.netOut_int);
        } else {
            netJson.put(NET_OUT_INT, 0);
        }
        if (this.netIn_ext != null) {
            netJson.put(NET_IN_EXT, (Object)this.netIn_ext);
        } else {
            netJson.put(NET_IN_EXT, 0);
        }
        if (this.netOut_ext != null) {
            netJson.put(NET_OUT_EXT, (Object)this.netOut_ext);
        } else {
            netJson.put(NET_OUT_EXT, 0);
        }
        json.put(NET, (Object)netJson);
        if (this.duration > 0) {
            json.put(DURATION, this.duration);
        } else {
            json.put(DURATION, 0);
        }
        if (this.startTime != null) {
            json.put(START, (Object)DateUtils.formatSqlDateTime(this.startTime));
        } else {
            json.put(START, (Object)"");
        }
        if (this.diskIoUsed != null) {
            json.put(DISK_IO_USED, (Object)this.diskIoUsed);
        } else {
            json.put(DISK_IO_USED, 0);
        }
        return json;
    }

    @Override
    public StatElement _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        if (json.has(CPU_MHZ)) {
            this.cpuMHz = json.getInt(CPU_MHZ);
        }
        if (json.has(CPU)) {
            this.cpuUsed = json.getInt(CPU);
        }
        if (json.has(MEM)) {
            this.memUsed = json.getInt(MEM);
        }
        if (json.has(CHANKUSED)) {
            this.chanksUsed = json.getInt(CHANKUSED);
        }
        if (json.has(CLOUDLETUSED)) {
            this.cloudletsUsed = json.getInt(CLOUDLETUSED);
        }
        if (json.has(CAPACITY)) {
            this.capacity = json.getInt(CAPACITY);
        }
        if (json.has(DISK)) {
            this.diskUsed = json.getInt(DISK);
        }
        if (json.has(IOPS_USED)) {
            this.diskIopsUsed = json.getInt(IOPS_USED);
        }
        if (json.has(IOPS_LIMIT)) {
            this.diskIopsLimit = json.getInt(IOPS_LIMIT);
        }
        if (json.has(NET)) {
            JSONObject jsonNet = json.getJSONObject(NET);
            if (jsonNet.has(NET_IN_INT)) {
                this.netIn_int = jsonNet.getLong(NET_IN_INT);
            }
            if (jsonNet.has(NET_OUT_INT)) {
                this.netOut_int = jsonNet.getLong(NET_OUT_INT);
            }
            if (jsonNet.has(NET_IN_EXT)) {
                this.netIn_ext = jsonNet.getLong(NET_IN_EXT);
            }
            if (jsonNet.has(NET_OUT_EXT)) {
                this.netOut_ext = jsonNet.getLong(NET_OUT_EXT);
            }
        }
        if (json.has(DURATION)) {
            this.duration = json.getInt(DURATION);
        }
        if (json.has(START) && !json.getString(START).isEmpty()) {
            try {
                this.startTime = DateUtils.parseSqlDateTime(json.getString(START));
            }
            catch (ParseException ex) {
                throw new JSONException((Throwable)ex);
            }
        }
        if (json.has(DISK_IO_USED)) {
            this.diskIoUsed = json.getInt(DISK_IO_USED);
        }
        return this;
    }

    public void merge(StatElement element) {
        this.duration += element.duration;
        StatElement statElement = this;
        statElement.cpuUsed = statElement.cpuUsed + element.getCpuUsed();
        this.memUsed = (this.memUsed + element.getMemUsed()) / 2;
        this.diskUsed = (this.diskUsed + element.getDiskUsed()) / 2;
        statElement = this;
        statElement.netIn_int = statElement.netIn_int + element.getNetInInt();
        statElement = this;
        statElement.netOut_int = statElement.netOut_int + element.getNetOutInt();
        statElement = this;
        statElement.netIn_ext = statElement.netIn_ext + element.getNetInExt();
        statElement = this;
        statElement.netOut_ext = statElement.netOut_ext + element.getNetOutExt();
        statElement = this;
        statElement.diskIopsUsed = statElement.diskIopsUsed + element.getDiskIopsUsed();
        statElement = this;
        statElement.diskIoUsed = statElement.diskIoUsed + element.getDiskIoUsed();
    }

    public void mergePeak(StatElement element) {
        this.duration += element.duration;
        this.cpuUsed = (this.cpuUsed + element.getCpuUsed()) / 2;
        this.memUsed = this.memUsed > element.getMemUsed() ? this.memUsed.intValue() : element.getMemUsed();
        this.diskUsed = this.diskUsed > element.getDiskUsed() ? this.diskUsed.intValue() : element.getDiskUsed();
        StatElement statElement = this;
        statElement.netIn_int = statElement.netIn_int + element.getNetInInt();
        statElement = this;
        statElement.netOut_int = statElement.netOut_int + element.getNetOutInt();
        statElement = this;
        statElement.netIn_ext = statElement.netIn_ext + element.getNetInExt();
        statElement = this;
        statElement.netOut_ext = statElement.netOut_ext + element.getNetOutExt();
        statElement = this;
        statElement.diskIopsUsed = statElement.diskIopsUsed + element.getDiskIopsUsed();
        statElement = this;
        statElement.diskIoUsed = statElement.diskIoUsed + element.getDiskIoUsed();
    }

    public void addition(StatElement element) {
        this.duration += element.duration;
        StatElement statElement = this;
        statElement.cpuUsed = statElement.cpuUsed + element.getCpuUsed();
        statElement = this;
        statElement.memUsed = statElement.memUsed + element.getMemUsed();
        statElement = this;
        statElement.diskUsed = statElement.diskUsed + element.getDiskUsed();
        statElement = this;
        statElement.netIn_int = statElement.netIn_int + element.getNetInInt();
        statElement = this;
        statElement.netOut_int = statElement.netOut_int + element.getNetOutInt();
        statElement = this;
        statElement.netIn_ext = statElement.netIn_ext + element.getNetInExt();
        statElement = this;
        statElement.netOut_ext = statElement.netOut_ext + element.getNetOutExt();
        statElement = this;
        statElement.diskIopsUsed = statElement.diskIopsUsed + element.getDiskIopsUsed();
        statElement = this;
        statElement.diskIoUsed = statElement.diskIoUsed + element.getDiskIoUsed();
    }

    public void fillWithZero() {
        this.fillWithZero(false);
    }

    public void fillWithZero(boolean isReplace) {
        if (isReplace || this.memUsed == null) {
            this.memUsed = 0;
        }
        if (isReplace || this.cpuUsed == null) {
            this.cpuUsed = 0;
        }
        if (isReplace || this.duration == -1) {
            this.duration = 0;
        }
        if (isReplace || this.netIn_int == null) {
            this.netIn_int = 0L;
        }
        if (isReplace || this.netOut_int == null) {
            this.netOut_int = 0L;
        }
        if (isReplace || this.netIn_ext == null) {
            this.netIn_ext = 0L;
        }
        if (isReplace || this.netOut_ext == null) {
            this.netOut_ext = 0L;
        }
        if (isReplace || this.diskUsed == null) {
            this.diskUsed = 0;
        }
        if (isReplace || this.diskIopsUsed == null) {
            this.diskIopsUsed = 0;
        }
        if (isReplace || this.diskIoUsed == null) {
            this.diskIoUsed = 0;
        }
    }

    @Override
    public int compareTo(StatElement t) {
        return this.startTime.compareTo(t.getStartTime());
    }
}

