/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.system.persistence;

import com.jelastic.api.development.response.interfaces.ArrayItem;
import com.jelastic.api.system.persistence.Engine;
import com.jelastic.api.system.persistence.HardwareNode;
import com.jelastic.api.system.persistence.OSType;
import com.jelastic.api.system.persistence.OsNode;
import com.jelastic.api.system.persistence.TemplateRegistry;
import com.jelastic.api.system.persistence.TemplateTag;
import com.jelastic.api.system.persistence.TemplateType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Template
extends ArrayItem {
    private static final Logger logger = Logger.getLogger(Template.class.getName());
    public static final String REGISTRY = "registry";
    public static final String TAGS = "tags";
    public static final String ENGINE_TYPE = "engineType";
    public static final String REPOSITORY = "repository";
    public static final String AUTO_UPDATE = "autoUpdate";
    public static final String KEEP_SELECTED_TAGS = "keepSelectedTags";
    public static final String UPDATE_DEFAULT_TAG = "updateDefaultTag";
    public static final String SCALING_MODE = "scalingMode";
    public static final String NODE_TYPE_ALIASES = "nodeTypeAliases";
    private int id;
    private String nodeType;
    private String description;
    private OsNode osNode;
    private String name;
    private String nodeMission;
    private List<Engine> engines;
    protected HardwareNode hn;
    protected String version;
    protected boolean cartridge;
    private String imagesData;
    private boolean enabled;
    private boolean published;
    private TemplateType type;
    private OSType osType = OSType.LINUX;
    private String manifestUrl;
    private TemplateRegistry registry;
    private Set<TemplateTag> tags = new HashSet<TemplateTag>();
    private String engineType;
    private String repository;
    private boolean autoUpdate;
    private boolean keepSelectedTags;
    private boolean updateDefaultTag;
    private String scalingMode;
    private Set<String> nodeTypeAliases;

    public Template(String templateName, String description, OsNode templateNode) {
        this.nodeType = templateName;
        this.description = description;
        this.osNode = templateNode;
    }

    public Template() {
    }

    public OSType getOsType() {
        return this.osType;
    }

    public void setOsType(OSType osType) {
        this.osType = osType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public OsNode getOsNode() {
        return this.osNode;
    }

    public void setOsNode(OsNode osNode) {
        this.osNode = osNode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNodeMission() {
        return this.nodeMission;
    }

    public void setNodeMission(String nodeMission) {
        this.nodeMission = nodeMission;
    }

    public List<Engine> getEngines() {
        return this.engines;
    }

    public void setEngines(List<Engine> engines) {
        this.engines = engines;
    }

    public HardwareNode getHn() {
        return this.hn;
    }

    public void setHn(HardwareNode hn) {
        this.hn = hn;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isCartridge() {
        return this.cartridge;
    }

    public void setCartridge(boolean cartridge) {
        this.cartridge = cartridge;
    }

    public String getImagesData() {
        return this.imagesData;
    }

    public void setImagesData(String imagesData) {
        this.imagesData = imagesData;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public TemplateRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(TemplateRegistry registry) {
        this.registry = registry;
    }

    public Set<TemplateTag> getTags() {
        return this.tags;
    }

    public void setTags(Set<TemplateTag> tags) {
        this.tags = tags;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public TemplateType getType() {
        return this.type;
    }

    public void setType(TemplateType type) {
        this.type = type;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isKeepSelectedTags() {
        return this.keepSelectedTags;
    }

    public void setKeepSelectedTags(boolean keepSelectedTags) {
        this.keepSelectedTags = keepSelectedTags;
    }

    public boolean isUpdateDefaultTag() {
        return this.updateDefaultTag;
    }

    public void setUpdateDefaultTag(boolean updateDefaultTag) {
        this.updateDefaultTag = updateDefaultTag;
    }

    public String getScalingMode() {
        return this.scalingMode;
    }

    public void setScalingMode(String scalingMode) {
        this.scalingMode = scalingMode;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", this.id);
        json.put("nodeType", (Object)this.nodeType);
        json.put("description", (Object)this.description);
        json.put("name", (Object)this.name);
        json.put("nodeMission", (Object)this.nodeMission);
        if (this.engines != null && !this.engines.isEmpty()) {
            JSONArray array = new JSONArray();
            for (Engine engine : this.engines) {
                array.put((Object)engine._toJSON());
            }
            json.put("engines", (Object)array);
        }
        if (this.hn != null) {
            json.put("hn", (Object)this.hn._toJSON());
        }
        if (this.imagesData != null) {
            json.put("imagesData", (Object)new JSONObject(this.imagesData));
        }
        json.put("version", (Object)this.version);
        json.put("type", this.type != null ? this.type.toString() : null);
        json.put("enabled", this.enabled);
        json.put("published", this.published);
        if (this.osType != null) {
            json.put("osType", (Object)this.osType.toString());
        }
        json.put("manifestUrl", (Object)this.manifestUrl);
        if (this.registry != null) {
            json.put(REGISTRY, (Object)this.registry._toJSON());
        }
        if (!this.tags.isEmpty()) {
            JSONArray tagsArray = new JSONArray();
            for (TemplateTag tag : this.tags) {
                tagsArray.put((Object)tag._toJSON());
            }
            json.put(TAGS, (Object)tagsArray);
        }
        json.put(ENGINE_TYPE, (Object)this.engineType);
        json.put(REPOSITORY, (Object)this.repository);
        json.put(AUTO_UPDATE, this.autoUpdate);
        json.put(KEEP_SELECTED_TAGS, this.keepSelectedTags);
        json.put(UPDATE_DEFAULT_TAG, this.updateDefaultTag);
        json.put(SCALING_MODE, (Object)this.scalingMode);
        if (this.nodeTypeAliases != null && !this.nodeTypeAliases.isEmpty()) {
            json.put(NODE_TYPE_ALIASES, this.nodeTypeAliases);
        }
        return json;
    }

    @Override
    public Template _fromJSON(JSONObject json) throws JSONException {
        JSONArray jsonArray;
        int i;
        if (json.has("id")) {
            this.id = json.getInt("id");
        }
        if (json.has("nodeType")) {
            this.nodeType = json.getString("nodeType");
        }
        if (json.has("description")) {
            this.description = json.getString("description");
        }
        if (json.has("name")) {
            this.name = json.getString("name");
        }
        if (json.has("nodeMission")) {
            this.nodeMission = json.getString("nodeMission");
        }
        if (json.has("engines")) {
            this.engines = new ArrayList<Engine>();
            JSONArray array = json.getJSONArray("engines");
            for (i = 0; i < array.length(); ++i) {
                this.engines.add(new Engine()._fromJSON(array.getJSONObject(i)));
            }
        }
        if (json.has("hn")) {
            this.hn = new HardwareNode()._fromJSON(json.getJSONObject("hn"));
        }
        if (json.has("type")) {
            try {
                this.type = TemplateType.valueOf(json.getString("type").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.SEVERE, "Can't parse template type '{}'", json.get("type"));
            }
        }
        if (json.has("imagesData")) {
            this.imagesData = json.getJSONObject("imagesData").toString();
        }
        if (json.has("version")) {
            this.version = json.getString("version");
        }
        if (json.has("enabled")) {
            this.enabled = json.getBoolean("enabled");
        }
        if (json.has("published")) {
            this.published = json.getBoolean("published");
        }
        if (json.has("osType")) {
            this.osType = OSType.valueOf(json.getString("osType"));
        }
        if (json.has("manifestUrl")) {
            this.manifestUrl = json.getString("manifestUrl");
        }
        if (json.has(REGISTRY)) {
            this.registry = new TemplateRegistry()._fromJSON(json.getJSONObject(REGISTRY));
        }
        if (json.has(TAGS)) {
            this.tags = new HashSet<TemplateTag>();
            JSONArray tagsArray = json.getJSONArray(TAGS);
            for (i = 0; i < tagsArray.length(); ++i) {
                this.tags.add(new TemplateTag()._fromJSON(tagsArray.getJSONObject(i)));
            }
        }
        if (json.has(ENGINE_TYPE)) {
            this.engineType = json.getString(ENGINE_TYPE);
        }
        if (json.has(REPOSITORY)) {
            this.repository = json.getString(REPOSITORY);
        }
        if (json.has(AUTO_UPDATE)) {
            this.autoUpdate = json.getBoolean(AUTO_UPDATE);
        }
        if (json.has(KEEP_SELECTED_TAGS)) {
            this.keepSelectedTags = json.getBoolean(KEEP_SELECTED_TAGS);
        }
        if (json.has(UPDATE_DEFAULT_TAG)) {
            this.updateDefaultTag = json.getBoolean(UPDATE_DEFAULT_TAG);
        }
        if (json.has(SCALING_MODE)) {
            this.scalingMode = json.getString(SCALING_MODE);
        }
        if (json.has(NODE_TYPE_ALIASES) && !json.isNull(NODE_TYPE_ALIASES) && (jsonArray = json.getJSONArray(NODE_TYPE_ALIASES)).length() > 0) {
            if (this.nodeTypeAliases == null) {
                this.nodeTypeAliases = new HashSet<String>(jsonArray.length());
            } else {
                this.nodeTypeAliases.clear();
            }
            for (i = 0; i < jsonArray.length(); ++i) {
                if (jsonArray.isNull(i)) continue;
                this.nodeTypeAliases.add(jsonArray.getString(i));
            }
        }
        return this;
    }
}

