/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.system.persistence;

import com.jelastic.api.data.po.BuildCustomData;
import com.jelastic.api.data.po.DBItem;
import com.jelastic.api.data.po.DockerMetadata;
import com.jelastic.api.development.response.interfaces.ArrayItem;
import com.jelastic.api.system.persistence.Addon;
import com.jelastic.api.system.persistence.ClusterGroup;
import com.jelastic.api.system.persistence.EndPoint;
import com.jelastic.api.system.persistence.ExtIpAddress;
import com.jelastic.api.system.persistence.HardwareNode;
import com.jelastic.api.system.persistence.OSType;
import com.jelastic.api.system.persistence.SoftNodeProperties;
import com.jelastic.api.system.persistence.SoftwarePackage;
import com.jelastic.api.system.persistence.TemplateType;
import com.jelastic.api.system.persistence.VCSBranch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SoftwareNode
extends ArrayItem
implements Serializable {
    private static final String IS_WEBACCESS = "isWebAccess";
    private static final String ADMIN_URL = "adminUrl";
    private static final String NODE_GROUP = "nodeGroup";
    private static final String ADDONS = "addons";
    private static final String IS_HIGH_AVAILABILITY = "isHighAvailability";
    private static final String IS_VCS_SUPPORT = "isVcsSupport";
    private static final String ENGINE_TYPE = "engineType";
    private static final String CLOUDLETS_MIN_COUNT = "cloudletsMinCount";
    public static final String CUSTOM_ITEM = "customitem";
    public static final String BUILD_CUSTOM_DATA = "buildCustomData";
    public static final String CTID = "ctid";
    private static final String IS_CUSTOM_SSL_SUPPORT = "isCustomSslSupport";
    protected int id;
    protected boolean isMaster;
    protected SoftwareNode origNode;
    protected Set<SoftwarePackage> packages;
    protected int maxchanks = -1;
    private boolean isDeleted;
    private Date deletedOn;
    protected SoftNodeProperties properties;
    private String customItem;
    private VCSBranch branch;
    private boolean isUpToDate;
    private Date createdOn;
    @Deprecated
    protected String address;
    protected String intIP;
    protected HardwareNode hn;
    protected ClusterGroup clusterGroup;
    protected List<ExtIpAddress> extIps;
    protected String url;
    protected Integer status;
    protected Long mem;
    protected Long hdd;
    private int flexibleCloudlets;
    private int fixedCloudlets;
    private String displayName;
    protected OSType osType;
    private List<EndPoint> endpoints = new ArrayList<EndPoint>();
    private String adminUrl;
    private String nodeGroup;
    private Set<Addon> addons = new HashSet<Addon>();
    private String engineType;
    private String buildCustomData;
    private Integer ctid;

    public List<EndPoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<EndPoint> endpoints) {
        this.endpoints = endpoints;
    }

    public OSType getOsType() {
        return this.osType;
    }

    public void setOsType(OSType osType) {
        this.osType = osType;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public int getMaxchanks() {
        return this.maxchanks;
    }

    public void setMaxchanks(int maxchanks) {
        this.maxchanks = maxchanks;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setIsMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public Set<SoftwarePackage> getPackages() {
        return this.packages;
    }

    public void setPackages(Set<SoftwarePackage> packages) {
        this.packages = packages;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Date getDeletedOn() {
        return this.deletedOn;
    }

    public void setDeletedOn(Date deletedOn) {
        this.deletedOn = deletedOn;
    }

    public SoftNodeProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SoftNodeProperties properties) {
        this.properties = properties;
    }

    public HardwareNode getHn() {
        return this.hn;
    }

    public void setHn(HardwareNode hn) {
        this.hn = hn;
    }

    public ClusterGroup getClusterGroup() {
        return this.clusterGroup;
    }

    public void setClusterGroup(ClusterGroup clusterGroup) {
        this.clusterGroup = clusterGroup;
    }

    public VCSBranch getBranch() {
        return this.branch;
    }

    public void setBranch(VCSBranch branch) {
        this.branch = branch;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public DBItem getCustomItem() {
        try {
            return new DockerMetadata(this.customItem);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String getIntIP() {
        return this.intIP;
    }

    public void setIntIP(String intIP) {
        this.intIP = intIP;
    }

    public void setCustomItem(DBItem dbItem) {
        this.customItem = dbItem.toString();
    }

    public void setRawCustomItem(String customitem) {
        this.customItem = customitem;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    public void setIsUpToDate(boolean isUpToDate) {
        this.isUpToDate = isUpToDate;
    }

    public List<ExtIpAddress> getExtIps() {
        return this.extIps;
    }

    public void setExtIps(List<ExtIpAddress> extIps) {
        this.extIps = extIps;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getMem() {
        return this.mem;
    }

    public void setMem(Long mem) {
        this.mem = mem;
    }

    public Long getHdd() {
        return this.hdd;
    }

    public void setHdd(Long hdd) {
        this.hdd = hdd;
    }

    public int getFlexibleCloudlets() {
        return this.flexibleCloudlets;
    }

    public void setFlexibleCloudlets(int flexibleCloudlets) {
        this.flexibleCloudlets = flexibleCloudlets;
    }

    public int getFixedCloudlets() {
        return this.fixedCloudlets;
    }

    public void setFixedCloudlets(int fixedCloudlets) {
        this.fixedCloudlets = fixedCloudlets;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public Set<Addon> getAddons() {
        return this.addons;
    }

    public void setAddons(Set<Addon> addons) {
        this.addons = addons;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public Integer getCtid() {
        return this.ctid;
    }

    public void setCtid(Integer ctid) {
        this.ctid = ctid;
    }

    public BuildCustomData getBuildCustomData() {
        if (this.buildCustomData == null) {
            return null;
        }
        return new BuildCustomData(this.buildCustomData);
    }

    public void setBuildCustomData(BuildCustomData buildCustomData) {
        this.buildCustomData = buildCustomData.toString();
    }

    public SoftwareNode cloneTo(SoftwareNode cloned) {
        cloned.setMaxchanks(this.maxchanks);
        cloned.setAddress(this.address);
        cloned.setIsMaster(this.isMaster);
        cloned.setProperties(this.properties);
        cloned.setBranch(this.branch);
        cloned.setIsUpToDate(this.isUpToDate);
        cloned.setRawCustomItem(this.customItem);
        return cloned;
    }

    public SoftwareNode clone() {
        SoftwareNode cloned = new SoftwareNode();
        return this.cloneTo(cloned);
    }

    public SoftwareNode getOrigNode() {
        return this.origNode;
    }

    public void setOrigNode(SoftwareNode origNode) {
        this.origNode = origNode;
    }

    private static JSONObject merge(JSONObject from, JSONObject to) throws JSONException {
        Iterator keys = from.keys();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            to.put(name, from.get(name));
        }
        return to;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        SoftwareNode other = (SoftwareNode)obj;
        return this.getId() == other.getId();
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", this.id);
        json.put("ismaster", this.isMaster);
        if (this.address != null) {
            json.put("address", (Object)this.address);
        }
        if (this.intIP != null) {
            json.put("intIP", (Object)this.intIP);
        }
        if (this.maxchanks != -1) {
            json.put("maxchanks", this.maxchanks);
        }
        if (this.properties != null) {
            if (this.properties.getPort() != -1) {
                json.put("port", this.properties.getPort());
            }
            json.put("nodeType", (Object)this.properties.getNodeType());
            json.put("nodemission", (Object)this.properties.getNodeMission());
            json.put("version", (Object)this.properties.getVersion());
            json.put("name", (Object)this.properties.getName());
            json.put("domainsuffix", (Object)this.properties.getDomainSuffix());
            json.put("isClusterSupport", this.properties.isClusterSupport());
            json.put("isExternalIpRequired", this.properties.isExternalIpRequired());
            json.put("isResetPassword", this.properties.isResetPassword());
            json.put("canBeExported", this.properties.canBeExported());
            json.put("type", this.properties.getType() != null ? this.properties.getType().toString() : null);
            json.put(IS_WEBACCESS, this.properties.isWebAccess());
            json.put(IS_VCS_SUPPORT, this.properties.isVcsSupport());
            json.put(IS_HIGH_AVAILABILITY, this.properties.isHighAvailability());
            json.put(CLOUDLETS_MIN_COUNT, (Object)this.properties.getCloudletsMinCount());
            boolean isBuildNodeWithBuildData = "build".equalsIgnoreCase(this.properties.getNodeMission()) && this.getBuildCustomData() != null;
            JSONObject buildCustomDataJsonObject = null;
            if (isBuildNodeWithBuildData) {
                buildCustomDataJsonObject = this.getBuildCustomData()._toJSON();
            }
            if (this.customItem != null && this.getCustomItem() != null) {
                boolean isDocker = "docker".equalsIgnoreCase(this.properties.getNodeMission());
                if (isDocker || this.properties.getType() == TemplateType.DOCKERIZED) {
                    try {
                        DockerMetadata dockerMetadata = new DockerMetadata(this.customItem);
                        if (isDocker) {
                            json.put("name", (Object)dockerMetadata.getName());
                        }
                        json.put("version", (Object)dockerMetadata.getTag());
                    }
                    catch (JSONException dockerMetadata) {
                        // empty catch block
                    }
                }
                JSONObject customItemJsonObject = this.getCustomItem()._toJSON();
                if (buildCustomDataJsonObject != null) {
                    SoftwareNode.merge(buildCustomDataJsonObject, customItemJsonObject);
                }
                json.put(CUSTOM_ITEM, (Object)customItemJsonObject);
            } else if (isBuildNodeWithBuildData) {
                json.put(CUSTOM_ITEM, (Object)buildCustomDataJsonObject);
            }
        }
        if (this.packages != null) {
            JSONArray jsonPcks = new JSONArray();
            for (SoftwarePackage pack : this.packages) {
                jsonPcks.put((Object)pack._toJSON());
            }
            json.put("packages", (Object)jsonPcks);
        }
        if (this.endpoints != null) {
            JSONArray jsonEndpoints = new JSONArray();
            for (EndPoint endPoint : this.endpoints) {
                jsonEndpoints.put((Object)endPoint._toJSON());
            }
            json.put("endpoints", (Object)jsonEndpoints);
        }
        if (this.hn != null) {
            json.put("hn", (Object)this.hn._toJSON());
        }
        if (this.clusterGroup != null) {
            json.put("clustergroupid", this.clusterGroup.getId());
        }
        if (this.osType != null) {
            json.put("osType", (Object)this.osType.toString());
        }
        if (this.extIps != null && this.extIps.size() > 0) {
            JSONArray ips = new JSONArray();
            for (ExtIpAddress extIp : this.extIps) {
                ips.put((Object)extIp.getIpAddress());
            }
            json.put("extips", (Object)ips);
            json.put("extIPs", (Object)ips);
        }
        json.put("url", (Object)this.url);
        json.put("status", (Object)this.status);
        json.put("mem", (Object)this.mem);
        json.put("hdd", (Object)this.hdd);
        json.put("flexibleCloudlets", this.flexibleCloudlets);
        json.put("fixedCloudlets", this.fixedCloudlets);
        json.put("displayName", (Object)this.displayName);
        json.put(ADMIN_URL, (Object)this.adminUrl);
        json.put(NODE_GROUP, (Object)this.nodeGroup);
        if (this.addons != null) {
            JSONArray jsonAddons = new JSONArray();
            for (Addon addon : this.addons) {
                jsonAddons.put((Object)addon._toJSON());
            }
            json.put(ADDONS, (Object)jsonAddons);
        }
        json.put(ENGINE_TYPE, (Object)this.engineType);
        json.put(CTID, (Object)this.ctid);
        json.put(IS_CUSTOM_SSL_SUPPORT, this.properties.isCustomSslSupport());
        return json;
    }

    @Override
    public SoftwareNode _fromJSON(JSONObject json) throws JSONException {
        JSONObject jsonObj;
        int i;
        if (json.has("id")) {
            this.id = json.getInt("id");
        }
        if (json.has("ismaster")) {
            this.isMaster = json.getBoolean("ismaster");
        }
        if (json.has("maxchanks")) {
            this.maxchanks = json.getInt("maxchanks");
        }
        if (json.has("address")) {
            this.address = json.getString("address");
        }
        if (json.has("intIP")) {
            this.intIP = json.getString("intIP");
        }
        this.properties = new SoftNodeProperties();
        if (json.has("port")) {
            this.properties.setPort(json.getInt("port"));
        }
        if (json.has("version")) {
            this.properties.setVersion(json.getString("version"));
        }
        if (json.has("nodeType")) {
            this.properties.setNodeType(json.getString("nodeType"));
        }
        if (json.has("canBeExported")) {
            this.properties.setCanBeExported(json.getBoolean("canBeExported"));
        }
        if (json.has("nodemission")) {
            this.properties.setNodeMission(json.getString("nodemission"));
        }
        if (json.has("domainsuffix")) {
            this.properties.setDomainSuffix(json.getString("domainsuffix"));
        }
        if (json.has("name")) {
            this.properties.setName(json.getString("name"));
        }
        if (json.has("isClusterSupport")) {
            this.properties.setClusterSupport(json.getBoolean("isClusterSupport"));
        }
        if (json.has("isExternalIpRequired")) {
            this.properties.setExternalIpRequired(json.getBoolean("isExternalIpRequired"));
        }
        if (json.has("isResetPassword")) {
            this.properties.setResetPassword(json.getBoolean("isResetPassword"));
        }
        if (json.has("type")) {
            try {
                this.properties.setType(TemplateType.valueOf(json.getString("type").toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (json.has(CUSTOM_ITEM) && this.properties.getNodeMission() != null) {
            JSONObject jsonObject = json.getJSONObject(CUSTOM_ITEM);
            if (TemplateType.DOCKERIZED.equals((Object)this.properties.getType()) || this.properties.getNodeMission().equalsIgnoreCase("docker")) {
                this.setCustomItem(new DockerMetadata(jsonObject));
            }
            if (this.properties.getNodeMission().equalsIgnoreCase("build")) {
                this.setBuildCustomData(new BuildCustomData(jsonObject));
            }
        }
        if (json.has(IS_WEBACCESS)) {
            this.properties.setWebAccess(json.getBoolean(IS_WEBACCESS));
        }
        if (json.has("packages")) {
            this.packages = new HashSet<SoftwarePackage>();
            JSONArray pcks = json.getJSONArray("packages");
            for (i = 0; i < pcks.length(); ++i) {
                jsonObj = (JSONObject)pcks.get(i);
                this.packages.add(new SoftwarePackage()._fromJSON(jsonObj));
            }
        }
        if (json.has("endpoints")) {
            this.endpoints = new ArrayList<EndPoint>();
            JSONArray jsonEndpoints = json.getJSONArray("endpoints");
            for (i = 0; i < jsonEndpoints.length(); ++i) {
                jsonObj = (JSONObject)jsonEndpoints.get(i);
                this.endpoints.add(new EndPoint()._fromJSON(jsonObj));
            }
        }
        if (json.has("hn")) {
            this.hn = new HardwareNode()._fromJSON(json.getJSONObject("hn"));
        }
        if (json.has("clustergroupid")) {
            this.clusterGroup = new ClusterGroup();
            this.clusterGroup.setId(json.getInt("clustergroupid"));
        }
        if (json.has("extips") || json.has("extIPs")) {
            JSONArray ips = json.has("extips") ? json.getJSONArray("extips") : json.getJSONArray("extIPs");
            this.extIps = new ArrayList<ExtIpAddress>();
            for (i = 0; i < ips.length(); ++i) {
                this.extIps.add(new ExtIpAddress(ips.getString(i), true));
            }
        }
        if (json.has("url")) {
            this.url = json.getString("url");
        }
        if (json.has("status")) {
            this.status = json.getInt("status");
        }
        if (json.has("mem")) {
            this.mem = json.getLong("mem");
        }
        if (json.has("hdd")) {
            this.hdd = json.getLong("hdd");
        }
        if (json.has("flexibleCloudlets")) {
            this.flexibleCloudlets = json.getInt("flexibleCloudlets");
        }
        if (json.has("fixedCloudlets")) {
            this.fixedCloudlets = json.getInt("fixedCloudlets");
        }
        if (json.has("displayName")) {
            this.displayName = json.getString("displayName");
        }
        if (json.has("osType")) {
            this.osType = OSType.valueOf(json.getString("osType"));
        }
        if (json.has(ADMIN_URL)) {
            this.adminUrl = json.getString(ADMIN_URL);
        }
        if (json.has(NODE_GROUP)) {
            this.nodeGroup = json.getString(NODE_GROUP);
        }
        if (json.has(ADDONS)) {
            this.addons = new HashSet<Addon>();
            JSONArray jsonAddons = json.getJSONArray(ADDONS);
            for (i = 0; i < jsonAddons.length(); ++i) {
                jsonObj = (JSONObject)jsonAddons.get(i);
                this.addons.add(new Addon()._fromJSON(jsonObj));
            }
        }
        if (json.has(IS_VCS_SUPPORT)) {
            this.properties.setVcsSupport(json.getBoolean(IS_VCS_SUPPORT));
        }
        if (json.has(IS_HIGH_AVAILABILITY)) {
            this.properties.setHighAvailability(json.getBoolean(IS_HIGH_AVAILABILITY));
        }
        if (json.has(CLOUDLETS_MIN_COUNT)) {
            this.properties.setCloudletsMinCount(json.getInt(CLOUDLETS_MIN_COUNT));
        }
        if (json.has(ENGINE_TYPE)) {
            this.engineType = json.getString(ENGINE_TYPE).toLowerCase();
        }
        if (json.has(CTID)) {
            this.ctid = json.getInt(CTID);
        }
        if (json.has(IS_CUSTOM_SSL_SUPPORT)) {
            this.properties.setCustomSslSupport(json.getBoolean(IS_CUSTOM_SSL_SUPPORT));
        }
        return this;
    }
}

