/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.system.persistence;

import com.jelastic.api.development.response.interfaces.ArrayItem;
import com.jelastic.api.system.persistence.AppContext;
import com.jelastic.api.system.persistence.AppNodes;
import com.jelastic.api.system.persistence.SoftwareNode;
import com.jelastic.api.system.persistence.TemplateType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SoftNodeGroup
extends ArrayItem {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String REDEPLOY_CONTAINER_DELAY = "redeployContainerDelay";
    public static final String RESTART_NODE_DELAY = "restartNodeDelay";
    public static final String RESTART_CONTAINER_DELAY = "restartContainerDelay";
    public static final String REDEPLOY_CONTEXT_DELAY = "redeployContextDelay";
    public static final String TEMPLATE_TYPE = "templateType";
    public static final String ENGINE_TYPE = "engineType";
    public static final String DEPLOYMENTS = "deployments";
    public static final String SCALING_MODE = "scalingMode";
    public static final String IS_SLB_ACCESS_ENABLED = "isSLBAccessEnabled";
    private String name;
    private AppNodes env;
    private Set<SoftwareNode> softwareNodes = new HashSet<SoftwareNode>();
    private int redeployContainerDelay;
    private int restartNodeDelay;
    private int restartContainerDelay;
    private int redeployContextDelay;
    private TemplateType templateType;
    private String engineType;
    private Set<AppContext> deployments = new HashSet<AppContext>();
    private String scalingMode;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean isSLBAccessEnabled;

    public SoftNodeGroup() {
    }

    public SoftNodeGroup(String name, int redeployContainerDelay, int restartNodeDelay, int restartContainerDelay, int redeployContextDelay) {
        this.name = name;
        this.redeployContainerDelay = redeployContainerDelay;
        this.restartNodeDelay = restartNodeDelay;
        this.restartContainerDelay = restartContainerDelay;
        this.redeployContextDelay = redeployContextDelay;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<SoftwareNode> getSoftwareNodes() {
        return this.softwareNodes;
    }

    public void setSoftwareNodes(Set<SoftwareNode> softwareNodes) {
        this.softwareNodes = softwareNodes;
    }

    public int getRedeployContainerDelay() {
        return this.redeployContainerDelay;
    }

    public void setRedeployContainerDelay(int redeployContainerDelay) {
        this.redeployContainerDelay = redeployContainerDelay;
    }

    public int getRestartNodeDelay() {
        return this.restartNodeDelay;
    }

    public void setRestartNodeDelay(int restartNodeDelay) {
        this.restartNodeDelay = restartNodeDelay;
    }

    public int getRestartContainerDelay() {
        return this.restartContainerDelay;
    }

    public void setRestartContainerDelay(int restartContainerDelay) {
        this.restartContainerDelay = restartContainerDelay;
    }

    public int getRedeployContextDelay() {
        return this.redeployContextDelay;
    }

    public void setRedeployContextDelay(int redeployContextDelay) {
        this.redeployContextDelay = redeployContextDelay;
    }

    public AppNodes getEnv() {
        return this.env;
    }

    public void setEnv(AppNodes env) {
        this.env = env;
    }

    public TemplateType getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(TemplateType templateType) {
        this.templateType = templateType;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public Set<AppContext> getDeployments() {
        return this.deployments;
    }

    public void setDeployments(Set<AppContext> deployments) {
        this.deployments = deployments;
    }

    public String getScalingMode() {
        return this.scalingMode;
    }

    public void setScalingMode(String scalingMode) {
        this.scalingMode = scalingMode;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean isSLBAccessEnabled() {
        return this.isSLBAccessEnabled;
    }

    public void setSLBAccessEnabled(boolean isSLBAccessEnabled) {
        this.isSLBAccessEnabled = isSLBAccessEnabled;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Object> keyValue : this.properties.entrySet()) {
            json.put(keyValue.getKey(), keyValue.getValue());
        }
        json.put(NAME, (Object)this.name);
        json.put(REDEPLOY_CONTAINER_DELAY, this.redeployContainerDelay);
        json.put(RESTART_NODE_DELAY, this.restartNodeDelay);
        json.put(RESTART_CONTAINER_DELAY, this.restartContainerDelay);
        json.put(REDEPLOY_CONTEXT_DELAY, this.redeployContextDelay);
        json.put(TEMPLATE_TYPE, (Object)this.templateType);
        json.put(ENGINE_TYPE, (Object)this.engineType);
        json.put(SCALING_MODE, (Object)this.scalingMode);
        json.put(IS_SLB_ACCESS_ENABLED, this.isSLBAccessEnabled);
        if (this.deployments != null) {
            JSONArray contextsJson = new JSONArray();
            for (AppContext context : this.deployments) {
                JSONObject contextJson = context._toJSON();
                contextsJson.put((Object)contextJson);
            }
            json.put(DEPLOYMENTS, (Object)contextsJson);
        }
        return json;
    }

    @Override
    public SoftNodeGroup _fromJSON(JSONObject json) throws JSONException {
        if (json.has(NAME)) {
            this.name = json.getString(NAME);
        }
        if (json.has(REDEPLOY_CONTAINER_DELAY)) {
            this.redeployContainerDelay = json.getInt(REDEPLOY_CONTAINER_DELAY);
        }
        if (json.has(RESTART_NODE_DELAY)) {
            this.restartNodeDelay = json.getInt(RESTART_NODE_DELAY);
        }
        if (json.has(RESTART_CONTAINER_DELAY)) {
            this.restartContainerDelay = json.getInt(RESTART_CONTAINER_DELAY);
        }
        if (json.has(REDEPLOY_CONTEXT_DELAY)) {
            this.redeployContextDelay = json.getInt(REDEPLOY_CONTEXT_DELAY);
        }
        if (json.has(TEMPLATE_TYPE)) {
            this.templateType = TemplateType.valueOf(json.getString(TEMPLATE_TYPE).toUpperCase());
        }
        if (json.has(ENGINE_TYPE)) {
            this.engineType = json.getString(ENGINE_TYPE).toLowerCase();
        }
        if (json.has(SCALING_MODE)) {
            this.scalingMode = json.getString(SCALING_MODE).toUpperCase();
        }
        if (json.has(DEPLOYMENTS)) {
            JSONArray contextsJson = json.getJSONArray(DEPLOYMENTS);
            for (int i = 0; i < contextsJson.length(); ++i) {
                JSONObject contextJson = contextsJson.getJSONObject(i);
                AppContext context = new AppContext()._fromJSON(contextJson);
                this.deployments.add(context);
            }
        }
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String fieldName = iterator.next().toString();
            Object fieldValue = null;
            if (!json.isNull(fieldName)) {
                try {
                    fieldValue = json.get(fieldName);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            this.properties.put(fieldName, fieldValue);
        }
        if (json.has(IS_SLB_ACCESS_ENABLED)) {
            this.isSLBAccessEnabled = json.getBoolean(IS_SLB_ACCESS_ENABLED);
        }
        return this;
    }
}

