/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.system.persistence;

import com.jelastic.api.development.response.interfaces.ArrayItem;
import com.jelastic.api.system.persistence.HardwareNodeGroupStatus;
import com.jelastic.api.system.persistence.OSType;
import com.jelastic.api.system.persistence.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HardwareNodeGroup
extends ArrayItem
implements Serializable {
    public static final String ID = "id";
    public static final String UNIQUE_NAME = "uniqueName";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String STATUS = "status";
    public static final String DOMAIN = "domain";
    public static final String OS_TYPES = "osTypes";
    public static final String IS_DEFAULT = "isDefault";
    public static final String IS_ENABLED = "isEnabled";
    public static final String VZ_TYPE = "vzType";
    public static final String VZ_TYPES = "vzTypes";
    private int id;
    private String uniqueName;
    private String displayName;
    private String description;
    private HardwareNodeGroupStatus status;
    private Region region;
    private Date createdOn;
    private Date deletedOn;
    private boolean isDeleted;
    private List<OSType> osTypes = new ArrayList<OSType>();
    private boolean isDefault;
    private boolean isEnabled;
    private Integer vzType;
    private Set<Integer> vzTypes = new HashSet<Integer>();

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HardwareNodeGroupStatus getStatus() {
        return this.status;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setStatus(HardwareNodeGroupStatus status) {
        this.status = status;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getDeletedOn() {
        return this.deletedOn;
    }

    public void setDeletedOn(Date deletedOn) {
        this.deletedOn = deletedOn;
    }

    public List<OSType> getOsTypes() {
        return this.osTypes;
    }

    public void setOsTypes(List<OSType> osTypes) {
        this.osTypes = osTypes;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put(ID, this.id);
        json.put(UNIQUE_NAME, (Object)this.uniqueName);
        json.put(DISPLAY_NAME, (Object)this.displayName);
        json.put(DESCRIPTION, (Object)this.description);
        json.put(STATUS, (Object)this.status);
        JSONArray osTypesJsonArray = new JSONArray();
        for (OSType osType : this.osTypes) {
            osTypesJsonArray.put((Object)osType);
        }
        json.put(OS_TYPES, (Object)osTypesJsonArray);
        json.put(IS_DEFAULT, this.isDefault);
        json.put(IS_ENABLED, this.isEnabled);
        json.put(VZ_TYPE, (Object)this.vzType);
        json.put(VZ_TYPES, this.vzTypes);
        return json;
    }

    @Override
    public HardwareNodeGroup _fromJSON(JSONObject json) throws JSONException {
        int i;
        if (json.has(ID)) {
            this.id = json.getInt(ID);
        }
        if (json.has(UNIQUE_NAME)) {
            this.uniqueName = json.getString(UNIQUE_NAME);
        }
        if (json.has(DISPLAY_NAME)) {
            this.displayName = json.getString(DISPLAY_NAME);
        }
        if (json.has(DESCRIPTION)) {
            this.description = json.getString(DESCRIPTION);
        }
        if (json.has(STATUS)) {
            this.status = HardwareNodeGroupStatus.valueOf(json.getString(STATUS));
        }
        if (json.has(OS_TYPES)) {
            this.osTypes.clear();
            JSONArray osTypesJsonArray = json.getJSONArray(OS_TYPES);
            for (i = 0; i < osTypesJsonArray.length(); ++i) {
                this.osTypes.add(OSType.valueOf(osTypesJsonArray.getString(i)));
            }
        }
        if (json.has(IS_DEFAULT)) {
            this.isDefault = json.getBoolean(IS_DEFAULT);
        }
        if (json.has(IS_ENABLED)) {
            this.isEnabled = json.getBoolean(IS_ENABLED);
        }
        if (json.has(VZ_TYPE)) {
            this.vzType = json.getInt(VZ_TYPE);
        }
        if (json.has(VZ_TYPES)) {
            this.vzTypes.clear();
            JSONArray vzTypesJsonArray = json.getJSONArray(VZ_TYPES);
            for (i = 0; i < vzTypesJsonArray.length(); ++i) {
                this.vzTypes.add(vzTypesJsonArray.getInt(i));
            }
        }
        return this;
    }
}

