/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.system.persistence;

import com.jelastic.api.development.response.interfaces.ArrayItem;
import com.jelastic.api.system.persistence.Credential;
import com.jelastic.api.system.persistence.Label;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class HardwareNode
extends ArrayItem
implements Serializable {
    private static final String LABELS = "labels";
    private static final String OS_TYPE = "osType";
    private static final String VZ_TYPE = "vzType";
    private int id;
    private String ipAddress;
    private int soapPort;
    private String soapProtocol;
    private String hostname;
    private Credential soapCredential;
    private int tcpPort = -1;
    private int power = 1217805;
    private int cpuNumber = 8;
    private int cpuFreq = 3000;
    private int sshPort = 22;
    private String hardwareNodeGroup;
    private String osType;
    private int vzType = -1;
    private Set<Label> labels = new HashSet<Label>();
    private String tcpProtocol;

    public int getCpuFreq() {
        return this.cpuFreq;
    }

    public void setCpuFreq(int cpuFreq) {
        this.cpuFreq = cpuFreq;
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }

    public void setCpuNumber(int cpuNumber) {
        this.cpuNumber = cpuNumber;
    }

    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public void setTcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
    }

    public String getTcpProtocol() {
        return this.tcpProtocol;
    }

    public void setTcpProtocol(String tcpProtocol) {
        this.tcpProtocol = tcpProtocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Credential getSoapCredential() {
        return this.soapCredential;
    }

    public void setSoapCredential(Credential soapCredential) {
        this.soapCredential = soapCredential;
    }

    public int getSoapPort() {
        return this.soapPort;
    }

    public void setSoapPort(int soapPort) {
        this.soapPort = soapPort;
    }

    public String getSoapProtocol() {
        return this.soapProtocol;
    }

    public void setSoapProtocol(String soapProtocol) {
        this.soapProtocol = soapProtocol;
    }

    public String getEndPointAddress() {
        return this.soapProtocol + "://" + this.ipAddress + ":" + this.getSoapPort();
    }

    public String getHardwareNodeGroup() {
        return this.hardwareNodeGroup;
    }

    public void setHardwareNodeGroup(String hardwareNodeGroup) {
        this.hardwareNodeGroup = hardwareNodeGroup;
    }

    public Set<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<Label> labels) {
        this.labels = labels;
    }

    public String getOsType() {
        return this.osType;
    }

    public void setOsType(String osType) {
        this.osType = osType;
    }

    public int getVzType() {
        return this.vzType;
    }

    public void setVzType(int vzType) {
        this.vzType = vzType;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        if (this.id != -1) {
            json.put("id", this.id);
        }
        if (this.ipAddress != null) {
            json.put("ipAddress", (Object)this.ipAddress);
        }
        if (this.soapPort != -1) {
            json.put("soapPort", this.soapPort);
        }
        if (this.soapProtocol != null) {
            json.put("soapProtocol", (Object)this.soapProtocol);
        }
        if (this.hostname != null) {
            json.put("hostname", (Object)this.hostname);
        }
        if (this.tcpPort != -1) {
            json.put("tcpPort", this.tcpPort);
        }
        if (this.power != -1) {
            json.put("power", this.power);
        }
        if (this.cpuNumber != -1) {
            json.put("cpuNumber", this.cpuNumber);
        }
        if (this.cpuFreq != -1) {
            json.put("cpuFreq", this.cpuFreq);
        }
        if (this.sshPort != -1) {
            json.put("sshPort", this.sshPort);
        }
        json.put("hardwareNodeGroup", (Object)this.hardwareNodeGroup);
        if (this.labels != null && !this.labels.isEmpty()) {
            JSONObject labelsJSON = new JSONObject();
            for (Label label : this.labels) {
                labelsJSON.put(label.getName(), (Object)label.getValue());
            }
            json.put(LABELS, (Object)labelsJSON);
        }
        if (this.osType != null) {
            json.put(OS_TYPE, (Object)this.osType);
        }
        if (this.vzType != -1) {
            json.put(VZ_TYPE, this.vzType);
        }
        return json;
    }

    @Override
    public HardwareNode _fromJSON(JSONObject json) throws JSONException {
        if (json.has("id")) {
            this.id = json.getInt("id");
        }
        if (json.has("ipAddress")) {
            this.ipAddress = json.getString("ipAddress");
        }
        if (json.has("soapPort")) {
            this.soapPort = json.getInt("soapPort");
        }
        if (json.has("soapProtocol")) {
            this.soapProtocol = json.getString("soapProtocol");
        }
        if (json.has("hostname")) {
            this.hostname = json.getString("hostname");
        }
        if (json.has("tcpPort")) {
            this.tcpPort = json.getInt("tcpPort");
        }
        if (json.has("cpuNumber")) {
            this.cpuNumber = json.getInt("cpuNumber");
        }
        if (json.has("cpuFreq")) {
            this.cpuFreq = json.getInt("cpuFreq");
        }
        if (json.has("tcpPort")) {
            this.tcpPort = json.getInt("tcpPort");
        }
        if (json.has("sshPort")) {
            this.sshPort = json.getInt("sshPort");
        }
        if (json.has("hardwareNodeGroup")) {
            this.hardwareNodeGroup = json.getString("hardwareNodeGroup");
        }
        if (json.has(LABELS)) {
            JSONObject labelsJSON = json.getJSONObject(LABELS);
            Map<String, String> labelsMap = HardwareNode.convertJSONObjectToStringMap(labelsJSON);
            for (Map.Entry<String, String> entry : labelsMap.entrySet()) {
                this.labels.add(new Label(entry.getKey(), entry.getValue()));
            }
        }
        if (json.has(OS_TYPE)) {
            this.osType = json.getString(OS_TYPE);
        }
        if (json.has(VZ_TYPE)) {
            this.vzType = json.getInt(VZ_TYPE);
        }
        return this;
    }
}

