/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.system.persistence;

public enum AuthType {
    BASIC(false),
    TFA(true);

    private boolean is2FA;

    private AuthType(boolean is2FA) {
        this.is2FA = is2FA;
    }

    public boolean is2FA() {
        return this.is2FA;
    }

    public static synchronized AuthType get(String string) {
        AuthType[] vals;
        if (string == null) {
            return null;
        }
        int id = -1;
        for (AuthType val : vals = AuthType.values()) {
            if (!val.toString().equalsIgnoreCase(string)) continue;
            return val;
        }
        try {
            id = Integer.parseInt(string);
        }
        catch (Exception ex) {
            return null;
        }
        return AuthType.get(id);
    }

    public static synchronized AuthType get(int id) {
        AuthType[] vals = AuthType.values();
        if (id > -1 && id < vals.length) {
            return vals[id];
        }
        return null;
    }

    public static String availableValues() {
        String availableValues = "";
        for (AuthType regionStatus : AuthType.values()) {
            availableValues = availableValues + " " + regionStatus.toString() + ",";
        }
        return availableValues.substring(0, availableValues.length() - 1);
    }
}

