/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.system.persistence;

import com.jelastic.api.development.response.interfaces.ArrayItem;
import com.jelastic.api.system.persistence.AppContext;
import com.jelastic.api.system.persistence.Domain;
import com.jelastic.api.system.persistence.Engine;
import com.jelastic.api.system.persistence.ExtDomain;
import com.jelastic.api.system.persistence.OsNode;
import com.jelastic.api.system.persistence.SoftwareNode;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppNodes
extends ArrayItem
implements Serializable {
    private static final String DOMAINS = "domains";
    private int id;
    private String appid;
    private String email;
    private Set<ExtDomain> extDomains = new HashSet<ExtDomain>();
    private Set<SoftwareNode> nodes = new HashSet<SoftwareNode>();
    private Set<AppContext> contexts = new HashSet<AppContext>();
    private int uid;
    private int creatorUid;
    private int status = 1;
    private String appname;
    private Domain domain;
    private OsNode masterNode;
    private String fullDomain;
    private Engine engine;
    private boolean sslState;
    private boolean isHAEnabled;
    private Boolean isBroken;
    private boolean isTransferring;
    private String displayName;
    private boolean isFirewallEnabled;
    private Set<String> domains = new HashSet<String>();

    public AppNodes(String appid) {
        this.appid = appid;
    }

    public AppNodes() {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public Set<SoftwareNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(Set<SoftwareNode> nodes) {
        this.nodes = nodes;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public int getCreatorUid() {
        return this.creatorUid;
    }

    public void setCreatorUid(int creatorUid) {
        this.creatorUid = creatorUid;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getAppname() {
        return this.appname;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    public Set<AppContext> getContexts() {
        return this.contexts;
    }

    public void setContexts(Set<AppContext> contexts) {
        this.contexts = contexts;
    }

    public OsNode getMasterNode() {
        return this.masterNode;
    }

    public void setMasterNode(OsNode masterNode) {
        this.masterNode = masterNode;
    }

    public String getFullDomain() {
        return this.fullDomain;
    }

    public void setFullDomain(String fullDomain) {
        this.fullDomain = fullDomain;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Set<ExtDomain> getExtDomains() {
        return this.extDomains;
    }

    public void setExtDomains(Set<ExtDomain> extDomains) {
        this.extDomains = extDomains;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public boolean getSslState() {
        return this.sslState;
    }

    public void setSslState(boolean sslState) {
        this.sslState = sslState;
    }

    public boolean isHAEnabled() {
        return this.isHAEnabled;
    }

    public void setHAEnabled(boolean isHAEnabled) {
        this.isHAEnabled = isHAEnabled;
    }

    public Boolean isTransferring() {
        return this.isTransferring;
    }

    public void setTransferring(Boolean isTransferring) {
        this.isTransferring = isTransferring;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isSslState() {
        return this.sslState;
    }

    public Boolean getBroken() {
        return this.isBroken;
    }

    public void setBroken(Boolean broken) {
        this.isBroken = broken;
    }

    public void setTransferring(boolean transferring) {
        this.isTransferring = transferring;
    }

    public boolean isFirewallEnabled() {
        return this.isFirewallEnabled;
    }

    public void setFirewallEnabled(boolean firewallEnabled) {
        this.isFirewallEnabled = firewallEnabled;
    }

    public Set<String> getDomains() {
        return this.domains;
    }

    public void setDomains(Set<String> domains) {
        this.domains = domains;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("status", this.status);
        json.put("appid", (Object)this.appid);
        json.put("sslstate", this.sslState);
        if (this.fullDomain != null) {
            json.put("domain", (Object)this.fullDomain);
            if (this.domain != null) {
                json.put("shortdomain", (Object)this.domain.getDomain());
                json.put("envName", (Object)this.domain.getDomain());
            }
        } else if (this.domain != null) {
            json.put("domain", (Object)this.domain.getDomain());
            json.put("shortdomain", (Object)this.domain.getDomain());
            json.put("envName", (Object)this.domain.getDomain());
        }
        if (this.uid != 0) {
            json.put("uid", this.uid);
        }
        if (this.creatorUid != 0) {
            json.put("creatorUid", this.creatorUid);
        }
        if (this.appname != null) {
            json.put("appname", (Object)this.appname);
        }
        if (this.engine != null) {
            json.put("engine", (Object)this.engine._toJSON());
        }
        if (this.contexts != null) {
            JSONArray contextsJson = new JSONArray();
            for (AppContext context : this.contexts) {
                JSONObject contextJson = context._toJSON();
                contextsJson.put((Object)contextJson);
            }
            json.put("contexts", (Object)contextsJson);
        }
        if (this.extDomains != null) {
            JSONArray domainsJson = new JSONArray();
            for (ExtDomain extDomain : this.extDomains) {
                domainsJson.put((Object)extDomain.getDomain());
            }
            json.put("extdomains", (Object)domainsJson);
        }
        json.put("ishaenabled", this.isHAEnabled);
        json.put("isFirewallEnabled", this.isFirewallEnabled);
        json.put("isBroken", (Object)this.isBroken);
        json.put("isTransferring", this.isTransferring);
        json.put("displayName", (Object)this.displayName);
        json.put(DOMAINS, this.domains);
        return json;
    }

    @Override
    public AppNodes _fromJSON(JSONObject json) throws JSONException {
        JSONArray domainsJson;
        int i;
        if (json.has("status")) {
            this.status = json.getInt("status");
        }
        if (json.has("appid")) {
            this.appid = json.getString("appid");
        }
        if (json.has("appname")) {
            this.appname = json.getString("appname");
        }
        if (json.has("domain")) {
            this.fullDomain = json.getString("domain");
        }
        if (json.has("envName") || json.has("shortdomain")) {
            Domain domain = this.domain = json.has("envName") ? new Domain(json.getString("envName")) : new Domain(json.getString("shortdomain"));
        }
        if (json.has("sslstate")) {
            this.sslState = json.getBoolean("sslstate");
        }
        if (json.has("uid")) {
            this.uid = json.getInt("uid");
        }
        if (json.has("creatorUid")) {
            this.creatorUid = json.getInt("creatorUid");
        }
        if (json.has("engine")) {
            this.engine = new Engine()._fromJSON(json.getJSONObject("engine"));
        }
        if (json.has("contexts")) {
            JSONArray contextsJson = json.getJSONArray("contexts");
            for (i = 0; i < contextsJson.length(); ++i) {
                JSONObject contextJson = contextsJson.getJSONObject(i);
                AppContext context = new AppContext()._fromJSON(contextJson);
                this.contexts.add(context);
            }
        }
        if (json.has("extdomains")) {
            domainsJson = json.getJSONArray("extdomains");
            for (i = 0; i < domainsJson.length(); ++i) {
                this.extDomains.add(new ExtDomain(domainsJson.getString(i)));
            }
        }
        if (json.has("ishaenabled")) {
            this.isHAEnabled = json.getBoolean("ishaenabled");
        }
        if (json.has("isBroken")) {
            this.isBroken = json.getBoolean("isBroken");
        }
        if (json.has("isTransferring")) {
            this.isTransferring = json.getBoolean("isTransferring");
        }
        if (json.has("displayName")) {
            this.displayName = json.getString("displayName");
        }
        if (json.has("isFirewallEnabled")) {
            this.isFirewallEnabled = json.getBoolean("isFirewallEnabled");
        }
        if (json.has(DOMAINS)) {
            domainsJson = json.getJSONArray(DOMAINS);
            for (i = 0; i < domainsJson.length(); ++i) {
                this.domains.add(domainsJson.getString(i));
            }
        }
        return this;
    }
}

