/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.statistic.response;

import com.jelastic.api.Response;
import com.jelastic.api.system.statistic.persistence.StatElement;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EnvironmentStatisticResponse
extends Response {
    private int status = -1;
    private String appid = null;
    private Boolean isTransferring = null;
    private List<StatElement> stats;

    public EnvironmentStatisticResponse(List<StatElement> stats, int status, String appid) {
        super(0);
        this.stats = stats;
        this.status = status;
        this.appid = appid;
    }

    public EnvironmentStatisticResponse(List<StatElement> stats, int status) {
        super(0);
        this.stats = stats;
        this.status = status;
    }

    public EnvironmentStatisticResponse(List<StatElement> stats) {
        super(0);
        this.stats = stats;
    }

    public EnvironmentStatisticResponse(StatElement stat) {
        this();
        this.stats.add(stat);
    }

    public EnvironmentStatisticResponse(StatElement stat, int status) {
        this();
        this.stats.add(stat);
        this.status = status;
    }

    public EnvironmentStatisticResponse() {
        super(0);
        this.stats = new ArrayList<StatElement>();
    }

    public EnvironmentStatisticResponse(int result, String error) {
        super(result, error);
    }

    public int getStatus() {
        return this.status;
    }

    public List<StatElement> getStats() {
        return this.stats;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = super._toJSON();
        if (this.stats != null) {
            JSONArray statsJson = new JSONArray();
            for (StatElement statElement : this.stats) {
                statsJson.put((Object)statElement._toJSON());
            }
            json.put("stats", (Object)statsJson);
        }
        if (this.status != -1) {
            json.put("status", this.status);
        }
        json.put("appid", (Object)this.appid);
        json.put("isTransferring", (Object)this.isTransferring);
        return json;
    }

    @Override
    protected EnvironmentStatisticResponse _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        this.stats = new ArrayList<StatElement>();
        if (json.has("stats")) {
            JSONArray statsJson = json.getJSONArray("stats");
            for (int i = 0; i < statsJson.length(); ++i) {
                JSONObject stat = statsJson.getJSONObject(i);
                this.stats.add(new StatElement()._fromJSON(stat));
            }
        }
        if (json.has("status")) {
            this.status = json.getInt("status");
        }
        if (json.has("appid")) {
            this.appid = json.getString("appid");
        }
        if (json.has("isTransferring")) {
            this.isTransferring = json.getBoolean("isTransferring");
        }
        return this;
    }
}

