/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.ssh;

import com.jelastic.api.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class SSHResponse
extends Response {
    private static final String OUT = "out";
    private static final String ERROR = "error";
    private static final String EXIT_STATUS = "exitStatus";
    private static final String ERR_OUT = "errOut";
    private String out;
    private String errOut;
    private int exitStatus = -1;

    public SSHResponse() {
        super(0);
    }

    public SSHResponse(int result, String error) {
        super(result, error);
    }

    public String getOut() {
        return this.out;
    }

    public void setOut(String out) {
        this.out = out;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
    }

    public String getErrOut() {
        return this.errOut;
    }

    public void setErrOut(String errOut) {
        this.errOut = errOut;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        try {
            if (this.out != null) {
                json.put(OUT, (Object)this.out);
            }
            if (this.error != null) {
                json.put(ERROR, (Object)this.error);
            }
            if (this.exitStatus > -1) {
                json.put(EXIT_STATUS, this.exitStatus);
            }
            json.put(ERR_OUT, (Object)this.errOut);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                json.put("result", 99).put(ERROR, (Object)ex.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return json;
    }

    @Override
    protected SSHResponse _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        if (json.has(OUT)) {
            this.out = json.getString(OUT);
        }
        if (json.has(ERROR)) {
            this.error = json.getString(ERROR);
        }
        if (json.has(EXIT_STATUS)) {
            try {
                this.exitStatus = json.getInt(EXIT_STATUS);
            }
            catch (JSONException ex) {
                this.exitStatus = -1;
            }
        }
        if (json.has(ERR_OUT)) {
            this.errOut = json.getString(ERR_OUT);
        }
        return this;
    }
}

