/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import com.jelastic.api.SSLCustom;
import com.jelastic.api.core.utils.DateUtils;
import java.text.ParseException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class SSLCustomResponse
extends Response {
    private SSLCustom sslCustom;

    public SSLCustomResponse() {
        super(0);
    }

    public SSLCustomResponse(SSLCustom sslCustom) {
        super(0);
        this.sslCustom = sslCustom;
    }

    public SSLCustomResponse(int result, String error) {
        super(result, error);
    }

    public SSLCustomResponse(int result, String error, String source, SSLCustom sslCustom) {
        super(result, error, source);
        this.sslCustom = sslCustom;
    }

    public SSLCustom getSslCustom() {
        return this.sslCustom;
    }

    public void setSslCustom(SSLCustom sslCustom) {
        this.sslCustom = sslCustom;
    }

    @Override
    protected JSONObject _toJSON() throws JSONException {
        JSONObject json = super._toJSON();
        if (this.sslCustom != null) {
            JSONObject sslCustomJson = new JSONObject();
            sslCustomJson.put("cert_key", (Object)this.sslCustom.getCertKey());
            sslCustomJson.put("cert", (Object)this.sslCustom.getCert());
            sslCustomJson.put("intermediate", (Object)this.sslCustom.getIntermediate());
            sslCustomJson.put("ssl_enable", this.sslCustom.isSslEnable());
            sslCustomJson.put("domain", (Object)this.sslCustom.getDomain());
            if (this.sslCustom.getExpireDate() != null) {
                sslCustomJson.put("expiredate", (Object)DateUtils.formatSqlDateTime(this.sslCustom.getExpireDate()));
            }
            json.put("sslCustom", (Object)sslCustomJson);
        }
        return json;
    }

    @Override
    public SSLCustomResponse _fromJSON(JSONObject json) {
        block4: {
            try {
                super._fromJSON(json);
                if (!json.has("sslCustom")) break block4;
                this.sslCustom.setCert(json.getString("cert"));
                this.sslCustom.setCertKey(json.getString("cert_key"));
                this.sslCustom.setIntermediate(json.getString("intermediate"));
                this.sslCustom.setSslEnable(json.getBoolean("ssl_enable"));
                this.sslCustom.setDomain(json.getString("domain"));
                Date expireDate = null;
                try {
                    expireDate = DateUtils.parseSqlDateTime(json.getString("expiredate"));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this.sslCustom.setExpireDate(expireDate);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return this;
    }
}

