/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import com.jelastic.api.core.utils.DateUtils;
import com.jelastic.api.environment.po.SSLCert;
import java.text.ParseException;
import org.json.JSONException;
import org.json.JSONObject;

public class SSLCertResponse
extends Response {
    private static final String ID = "id";
    private static final String DOMAINS = "domains";
    private static final String EXPIRES_AT = "expiresAt";
    private static final String ISSUED_BY = "issuedBy";
    private SSLCert sslCert;

    public SSLCertResponse() {
        super(0);
    }

    public SSLCertResponse(int result, String error) {
        super(result, error);
    }

    private SSLCertResponse(SSLCert sslCert) {
        super(0);
        this.sslCert = sslCert;
    }

    public static SSLCertResponse of(SSLCert sslCert) {
        return new SSLCertResponse(sslCert);
    }

    @Override
    protected JSONObject _toJSON() throws JSONException {
        JSONObject json = super._toJSON();
        this.sslCertToJson(json);
        return json;
    }

    @Override
    protected Response _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        this.sslCert.setId(json.optInt(ID));
        this.sslCert.setDomains(json.optString(DOMAINS));
        try {
            this.sslCert.setExpiresAt(DateUtils.parseSqlDateTime(json.optString(EXPIRES_AT)));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.sslCert.setIssuedBy(json.optString(ISSUED_BY));
        return this;
    }

    private void sslCertToJson(JSONObject json) throws JSONException {
        if (this.sslCert == null) {
            return;
        }
        json.put(ID, this.sslCert.getId());
        json.put(DOMAINS, (Object)this.sslCert.getDomains());
        json.put(EXPIRES_AT, (Object)DateUtils.formatSqlDateTime(this.sslCert.getExpiresAt()));
        json.put(ISSUED_BY, (Object)this.sslCert.getIssuedBy());
    }
}

