/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import com.jelastic.api.environment.po.RemouteFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogsListResponse
extends Response {
    private static final String ARRAY = "array";
    private static final String PATH = "path";
    private static final String PERMISSION = "permission";
    private static final String NAME = "name";
    private static final String SIZE = "size";
    private static final String ITEMS = "items";
    private static final String TYPE = "type";
    private Map<String, List<RemouteFile>> directories;
    private Map<String, List<RemouteFile>> groups;
    private Map<String, List<RemouteFile>> rotatedLogs;
    private String path;

    public LogsListResponse(Map<String, List<RemouteFile>> directories, Map<String, List<RemouteFile>> groups, Map<String, List<RemouteFile>> rotatedLogs, String path) {
        super(0);
        this.directories = directories;
        this.groups = groups;
        this.rotatedLogs = rotatedLogs;
        this.path = path;
    }

    public LogsListResponse(int result, String error) {
        super(result, error);
    }

    public LogsListResponse() {
        super(0);
    }

    public Map<String, List<RemouteFile>> getDirectories() {
        return this.directories;
    }

    public Map<String, List<RemouteFile>> getGroups() {
        return this.groups;
    }

    public Map<String, List<RemouteFile>> getRotatedLogs() {
        return this.rotatedLogs;
    }

    public void setDirectories(Map<String, List<RemouteFile>> directories) {
        this.directories = directories;
    }

    public void setGroups(Map<String, List<RemouteFile>> groups) {
        this.groups = groups;
    }

    public void setRotatedLogs(Map<String, List<RemouteFile>> rotatedLogs) {
        this.rotatedLogs = rotatedLogs;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public LogsListResponse fromJSON(JSONObject json) {
        Response response = super.fromJSON(json);
        try {
            if (json.has(ARRAY)) {
                this.directories = new HashMap<String, List<RemouteFile>>();
                this.groups = new HashMap<String, List<RemouteFile>>();
                this.rotatedLogs = new HashMap<String, List<RemouteFile>>();
                JSONArray itemArray = json.getJSONArray(ARRAY);
                for (int i = 0; i < itemArray.length(); ++i) {
                    JSONObject itemObject = itemArray.getJSONObject(i);
                    String name = "";
                    if (itemObject.has(NAME)) {
                        name = itemObject.getString(NAME);
                    }
                    String path = "";
                    if (itemObject.has(PATH)) {
                        path = itemObject.getString(PATH);
                    }
                    String permissions = "";
                    if (itemObject.has(PERMISSION)) {
                        permissions = itemObject.getString(PERMISSION);
                    }
                    ItemType itemType = ItemType.FILE;
                    if (itemObject.has(TYPE)) {
                        itemType = ItemType.valueOf(itemObject.getString(TYPE));
                    }
                    ArrayList<RemouteFile> remoteFiles = new ArrayList<RemouteFile>();
                    if (itemObject.has(ITEMS)) {
                        JSONArray itemsArray = itemObject.getJSONArray(ITEMS);
                        for (int j = 0; j < itemsArray.length(); ++j) {
                            JSONObject itemJSON = itemsArray.getJSONObject(j);
                            RemouteFile file = new RemouteFile();
                            if (itemJSON.has(TYPE)) {
                                file.setIsDir(itemJSON.getString(TYPE).equalsIgnoreCase(ItemType.DIRECTORY.toString()));
                            }
                            if (itemJSON.has(PATH)) {
                                file.setPath(itemJSON.getString(PATH));
                            }
                            if (itemJSON.has(NAME)) {
                                file.setName(itemJSON.getString(NAME));
                            }
                            if (itemJSON.has(SIZE)) {
                                file.setLength(itemJSON.getLong(SIZE));
                            }
                            if (itemJSON.has(PERMISSION)) {
                                file.setPermission(itemJSON.getString(PERMISSION));
                            }
                            remoteFiles.add(file);
                        }
                    }
                    remoteFiles.add(new RemouteFile(path, name, permissions, true, 0L));
                    if (itemType == ItemType.DIRECTORY) {
                        this.directories.put(name, remoteFiles);
                        continue;
                    }
                    if (itemType == ItemType.GROUP) {
                        this.groups.put(name, remoteFiles);
                        continue;
                    }
                    if (itemType != ItemType.ROTATED_LOGS) continue;
                    this.rotatedLogs.put(name, remoteFiles);
                }
            }
        }
        catch (JSONException ex) {
            response = new Response(99, ex.toString());
        }
        this.setResult(response.getResult());
        this.setError(response.getError());
        return this;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        JSONArray items = new JSONArray();
        try {
            this.addItems(items, this.directories, ItemType.DIRECTORY);
            this.addItems(items, this.groups, ItemType.GROUP);
            this.addItems(items, this.rotatedLogs, ItemType.ROTATED_LOGS);
            json.put(ARRAY, (Object)items);
        }
        catch (Exception ex) {
            try {
                json.put("result", 99).put("error", (Object)ex.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return json;
    }

    private void addItems(JSONArray items, Map<String, List<RemouteFile>> itemsMap, ItemType itemType) throws JSONException {
        if (itemsMap != null) {
            for (String name : itemsMap.keySet()) {
                JSONArray itemArray = new JSONArray();
                String permission = "";
                ArrayList sortedFiles = new ArrayList(itemsMap.get(name));
                for (RemouteFile file : sortedFiles) {
                    if (itemType == ItemType.DIRECTORY && file.getPath().equals(this.path)) {
                        permission = file.getPermission();
                        if (file.isDirectory()) continue;
                    }
                    JSONObject itemJson = new JSONObject();
                    itemJson.put(TYPE, (Object)(file.isDirectory() ? ItemType.DIRECTORY : ItemType.FILE));
                    itemJson.put(PATH, (Object)file.getPath());
                    itemJson.put(NAME, (Object)file.getName());
                    itemJson.put(PERMISSION, (Object)file.getPermission());
                    if (!file.isDirectory()) {
                        itemJson.put(SIZE, file.length());
                    }
                    itemArray.put((Object)itemJson);
                }
                JSONObject itemJson = new JSONObject();
                itemJson.put(NAME, (Object)name);
                itemJson.put(ITEMS, (Object)itemArray);
                itemJson.put(TYPE, (Object)itemType);
                if (itemType == ItemType.DIRECTORY) {
                    itemJson.put(PATH, (Object)this.path);
                    itemJson.put(PERMISSION, (Object)permission);
                }
                items.put((Object)itemJson);
            }
        }
    }

    public static enum ItemType {
        FILE,
        DIRECTORY,
        GROUP,
        ROTATED_LOGS;

    }
}

