/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import com.jelastic.api.environment.po.RemouteFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FilesListResponse
extends Response {
    private Map<String, List<RemouteFile>> keywords;
    private String coreRootPath;

    public FilesListResponse(Map<String, List<RemouteFile>> filesMap) {
        super(0);
        this.keywords = filesMap;
    }

    public FilesListResponse(int result, String error) {
        super(result, error);
    }

    public FilesListResponse() {
        super(0);
    }

    public FilesListResponse(Map<String, List<RemouteFile>> filesMap, String rootPath) {
        super(0);
        this.keywords = filesMap;
        this.coreRootPath = rootPath;
    }

    public Map<String, List<RemouteFile>> getFilesMap() {
        return this.keywords;
    }

    public void setFilesMap(Map<String, List<RemouteFile>> filesMap) {
        this.keywords = filesMap;
    }

    @Override
    public FilesListResponse fromJSON(JSONObject json) {
        Response response = super.fromJSON(json);
        try {
            if (json.has("keywords")) {
                this.keywords = new HashMap<String, List<RemouteFile>>();
                JSONArray keywords = json.getJSONArray("keywords");
                for (int i = 0; i < keywords.length(); ++i) {
                    JSONObject keywordObject = keywords.getJSONObject(i);
                    String keyword = "";
                    if (keywordObject.has("keyword")) {
                        keyword = keywordObject.getString("keyword");
                    }
                    String path = "";
                    if (keywordObject.has("path")) {
                        path = keywordObject.getString("path");
                    }
                    String permissions = "";
                    if (keywordObject.has("permission")) {
                        permissions = keywordObject.getString("permission");
                    }
                    ArrayList<RemouteFile> remoteFiles = new ArrayList<RemouteFile>();
                    if (keywordObject.has("files")) {
                        JSONArray filesArray = keywordObject.getJSONArray("files");
                        for (int j = 0; j < filesArray.length(); ++j) {
                            JSONObject fileJson = filesArray.getJSONObject(j);
                            RemouteFile file = new RemouteFile();
                            if (fileJson.has("isdir")) {
                                file.setIsDir(fileJson.getBoolean("isdir"));
                            }
                            if (fileJson.has("path")) {
                                file.setPath(fileJson.getString("path"));
                            }
                            if (fileJson.has("name")) {
                                file.setName(fileJson.getString("name"));
                            }
                            if (fileJson.has("length")) {
                                file.setLength(fileJson.getLong("length"));
                            }
                            if (fileJson.has("permission")) {
                                file.setPermission(fileJson.getString("permission"));
                            }
                            remoteFiles.add(file);
                        }
                    }
                    remoteFiles.add(new RemouteFile(path, keyword, permissions, true, 0L));
                    this.keywords.put(keyword, remoteFiles);
                }
            }
        }
        catch (JSONException ex) {
            response = new Response(99, ex.toString());
        }
        this.setResult(response.getResult());
        this.setError(response.getError());
        return this;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        JSONArray keywords = new JSONArray();
        try {
            if (this.keywords != null) {
                for (String keyword : this.keywords.keySet()) {
                    JSONArray filesArray = new JSONArray();
                    String rootPath = "";
                    String permission = "";
                    ArrayList sortedFiles = new ArrayList(this.keywords.get(keyword));
                    for (RemouteFile file : sortedFiles) {
                        if (this.coreRootPath == null) {
                            if (keyword.equals(file.getName()) && file.isRoot()) {
                                rootPath = file.getPath();
                                permission = file.getPermission();
                                if (file.isDirectory()) {
                                    continue;
                                }
                            }
                        } else if (file.getPath().equals(this.coreRootPath)) {
                            rootPath = file.getPath();
                            permission = file.getPermission();
                            if (file.isDirectory()) continue;
                        }
                        JSONObject fileJson = new JSONObject();
                        fileJson.put("isdir", file.isDirectory());
                        fileJson.put("path", (Object)file.getPath());
                        fileJson.put("name", (Object)file.getName());
                        fileJson.put("permission", (Object)file.getPermission());
                        if (!file.isDirectory()) {
                            fileJson.put("length", file.length());
                        }
                        filesArray.put((Object)fileJson);
                    }
                    keywords.put((Object)new JSONObject().put("keyword", (Object)keyword).put("path", (Object)rootPath).put("permission", (Object)permission).put("files", (Object)filesArray));
                }
                json.put("keywords", (Object)keywords);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                json.put("result", 99).put("error", (Object)ex.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return json;
    }
}

