/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import com.jelastic.api.system.persistence.ExtDomain;
import org.json.JSONException;
import org.json.JSONObject;

public class ExtDomainResponse
extends Response {
    private ExtDomain extDomain = new ExtDomain();

    public ExtDomainResponse() {
        super(0);
    }

    public ExtDomainResponse(int result, String error) {
        super(result, error);
    }

    public ExtDomainResponse(Response response, ExtDomain extDomain) {
        super(response);
        this.extDomain = extDomain;
    }

    public ExtDomain getExtDomain() {
        return this.extDomain;
    }

    public void setExtDomain(ExtDomain extDomain) {
        this.extDomain = extDomain;
    }

    @Override
    public ExtDomainResponse fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.extDomain.setId(json.optInt("id"));
        this.extDomain.setDomain(json.optString("domain", null));
        this.extDomain.setSslEnabled(json.optBoolean("sslEnabled"));
        return this;
    }

    @Override
    public JSONObject toJSON() {
        try {
            String domain;
            JSONObject json = super._toJSON();
            if (this.extDomain == null) {
                return json;
            }
            int id = this.extDomain.getId();
            if (id > 0) {
                json.put("id", id);
            }
            if ((domain = this.extDomain.getDomain()) != null && !domain.isEmpty()) {
                json.put("domain", (Object)domain);
            }
            boolean isSslEnabled = this.extDomain.isSslEnabled();
            json.put("sslEnabled", isSslEnabled);
            if (isSslEnabled) {
                json.put("sslExpiredDate", (Object)this.extDomain.getSslExpireDate());
                json.put("issuedBy", (Object)this.extDomain.getIssuedBy());
            }
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

