/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import com.jelastic.api.development.persistence.ApplicationRight;
import com.jelastic.api.system.persistence.AppNodes;
import com.jelastic.api.system.persistence.SoftNodeGroup;
import com.jelastic.api.system.persistence.SoftwareNode;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EnvironmentInfoResponse
extends Response {
    private AppNodes env;
    private Set<SoftwareNode> nodes;
    private ApplicationRight right;
    private Set<SoftNodeGroup> softNodeGroups;
    private Set<String> envGroups;

    public EnvironmentInfoResponse(Response response) {
        super(response.getResult(), response.getError());
    }

    public EnvironmentInfoResponse() {
        super(0);
    }

    public EnvironmentInfoResponse(int result, String error) {
        super(result, error);
    }

    public EnvironmentInfoResponse(int result, String error, String appid) {
        super(result, error);
        this.env = new AppNodes();
        this.env.setAppid(appid);
    }

    @Deprecated
    public AppNodes getAppNodes() {
        return this.env;
    }

    @Deprecated
    public void setAppNodes(AppNodes appNodes) {
        this.env = appNodes;
    }

    public AppNodes getEnv() {
        return this.env;
    }

    public void setEnv(AppNodes env) {
        this.env = env;
    }

    public Set<SoftwareNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(Set<SoftwareNode> nodes) {
        this.nodes = nodes;
    }

    public ApplicationRight getRight() {
        return this.right;
    }

    public void setRight(ApplicationRight right) {
        this.right = right;
    }

    public Set<String> getEnvGroups() {
        return this.envGroups;
    }

    public void setEnvGroups(Set<String> envGroups) {
        this.envGroups = envGroups;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = super._toJSON();
        if (this.env != null) {
            json.put("env", (Object)this.env._toJSON());
        }
        if (this.nodes != null) {
            JSONArray nodesJson = new JSONArray();
            for (SoftwareNode node : this.nodes) {
                nodesJson.put((Object)node._toJSON());
            }
            json.put("nodes", (Object)nodesJson);
        }
        if (this.right != null) {
            json.put("right", (Object)this.right.name());
        }
        if (this.softNodeGroups != null) {
            JSONArray nodeGroupsArray = new JSONArray();
            for (SoftNodeGroup softNodeGroup : this.softNodeGroups) {
                nodeGroupsArray.put((Object)softNodeGroup._toJSON());
            }
            json.put("nodeGroups", (Object)nodeGroupsArray);
        }
        if (this.envGroups != null) {
            JSONArray envGroupsArray = new JSONArray();
            for (String envGroup : this.envGroups) {
                envGroupsArray.put((Object)envGroup);
            }
            json.put("envGroups", (Object)envGroupsArray);
        }
        return json;
    }

    @Override
    public EnvironmentInfoResponse _fromJSON(JSONObject json) throws JSONException {
        int i;
        super._fromJSON(json);
        if (json.has("env")) {
            this.env = new AppNodes()._fromJSON(json.getJSONObject("env"));
        }
        if (json.has("nodes")) {
            JSONArray nodesJson = json.getJSONArray("nodes");
            this.nodes = new HashSet<SoftwareNode>();
            for (i = 0; i < nodesJson.length(); ++i) {
                JSONObject stat = nodesJson.getJSONObject(i);
                this.nodes.add(new SoftwareNode()._fromJSON(stat));
            }
        }
        if (json.has("right")) {
            this.right = ApplicationRight.get(json.getString("right"));
        }
        if (json.has("nodeGroups")) {
            JSONArray nodeGroupsArray = json.getJSONArray("nodeGroups");
            this.softNodeGroups = new HashSet<SoftNodeGroup>();
            for (i = 0; i < nodeGroupsArray.length(); ++i) {
                this.softNodeGroups.add(new SoftNodeGroup()._fromJSON(nodeGroupsArray.getJSONObject(i)));
            }
        }
        if (json.has("envGroups")) {
            JSONArray envGroupsArray = json.getJSONArray("envGroups");
            this.envGroups = new HashSet<String>();
            for (i = 0; i < envGroupsArray.length(); ++i) {
                this.envGroups.add(envGroupsArray.getString(i));
            }
        }
        return this;
    }
}

