/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DomainsResponse
extends Response {
    private static final String ENV = "env";
    private static final String NODE_GROUPS = "nodeGroups";
    private static final String NODE_GROUP = "nodeGroup";
    private static final String NODES = "nodes";
    private static final String NODE_ID = "nodeId";
    private static final String DOMAINS = "domains";
    private Set<String> envDomains;
    private Map<String, Set<String>> nodeGroupsDomains;
    private Map<String, Set<String>> nodesDomains;

    public DomainsResponse() {
        super(0);
    }

    public DomainsResponse(int result, String error) {
        super(result, error);
    }

    public Set<String> getEnvDomains() {
        return this.envDomains;
    }

    public void setEnvDomains(Set<String> envDomains) {
        this.envDomains = envDomains;
    }

    public Map<String, Set<String>> getNodeGroupsDomains() {
        return this.nodeGroupsDomains;
    }

    public void setNodeGroupsDomains(Map<String, Set<String>> nodeGroupsDomains) {
        this.nodeGroupsDomains = nodeGroupsDomains;
    }

    public Map<String, Set<String>> getNodesDomains() {
        return this.nodesDomains;
    }

    public void setNodesDomains(Map<String, Set<String>> nodesDomains) {
        this.nodesDomains = nodesDomains;
    }

    @Override
    public DomainsResponse _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        if (json.has(ENV)) {
            this.envDomains = this.convertJsonArrayToSet(json.getJSONArray(ENV));
        }
        this.nodeGroupsDomains = this.fillDomainsMap(json, NODE_GROUPS, NODE_GROUP);
        this.nodesDomains = this.fillDomainsMap(json, NODES, NODE_ID);
        return this;
    }

    private Map<String, Set<String>> fillDomainsMap(JSONObject json, String name, String idName) throws JSONException {
        HashMap<String, Set<String>> domainsMap = new HashMap<String, Set<String>>();
        if (json.has(name)) {
            JSONArray jsonArray = json.getJSONArray(name);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String key = jsonObject.getString(idName);
                domainsMap.put(key, this.convertJsonArrayToSet(jsonObject.getJSONArray(DOMAINS)));
            }
        }
        return domainsMap;
    }

    private JSONArray getDomainsJSONArray(Map<String, Set<String>> domains, String idName, boolean convertIdValuetoInt) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<String, Set<String>> entry : domains.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            String idValue = entry.getKey();
            jsonObject.put(idName, convertIdValuetoInt ? Integer.valueOf(idValue) : idValue);
            jsonObject.put(DOMAINS, (Collection)entry.getValue());
            jsonArray.put((Object)jsonObject);
        }
        return jsonArray;
    }

    private JSONArray getDomainsJSONArray(Map<String, Set<String>> domains, String idName) throws JSONException {
        return this.getDomainsJSONArray(domains, idName, false);
    }

    private Set<String> convertJsonArrayToSet(JSONArray jsonArray) {
        HashSet<String> itemSet = new HashSet<String>();
        for (int i = 0; i < jsonArray.length() - 1; ++i) {
            try {
                itemSet.add(jsonArray.getString(i));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return itemSet;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = super._toJSON();
        if (this.envDomains != null) {
            json.put(ENV, this.envDomains);
        }
        if (this.nodeGroupsDomains != null) {
            json.put(NODE_GROUPS, (Object)this.getDomainsJSONArray(this.nodeGroupsDomains, NODE_GROUP));
        }
        if (this.nodesDomains != null) {
            json.put(NODES, (Object)this.getDomainsJSONArray(this.nodesDomains, NODE_ID, true));
        }
        return json;
    }
}

